// @flow
import $ from 'jquery';

import * as xhr from 'codescene-ui/src/browser/xhr';
import * as alerts from 'codescene-ui/src/alerts';
import KnowledgeMap from 'codescene-ui/src/analyses/knowledge-map';

type ViewOptions = {
  minimumLabelSize : number,
  knowledgeLossUrl : string
};

export function init(options : ViewOptions) {
  var container =  $('#knowledgeloss');
  var showLabelsToggle =  $('#show-labels-toggle');
  var map = new KnowledgeMap(container, options.minimumLabelSize);

  xhr.json(options.knowledgeLossUrl)
    .then(knowledgeLoss => {
      map.draw(knowledgeLoss);
    })
    .catch(err => {
      console.error(err);
      alerts.error(container, 'Failed to load knowledge loss data.');
    });

  showLabelsToggle.on('change', () => {
    map.toggleLabels(showLabelsToggle.is(':checked'));
  });
}
