-- name: delete-version-information!
-- Deletes all existing version-information.
DELETE from version_information;

-- name: insert-version-information!
-- insert the latest_version, latest_stable_version and minimal_version.
INSERT INTO version_information
(latest_version, latest_stable_version, minimal_version)
values (:latest_version, :latest_stable_version, :minimal_version);

-- name: get-version-information
-- retrieve the latest version information stored
SELECT * FROM version_information;

-- name: get-user-version-information-acknowledge
-- retrieve the latest version information stored
SELECT * FROM user_version_information_acknowledge
WHERE provider = :provider AND username = :username AND version = :version;

-- name: insert-user-version-information-acknowledge!
-- insert the version acknowledged by the user with provider
INSERT INTO user_version_information_acknowledge
(id, provider, username, version)
VALUES (null, :provider, :username, :version);
