-- name: max-concurrent-analyses
-- Returns the configuration to the scheduler.
SELECT concurrent_analyses FROM concurrent_analysis_scheduling;

-- name: update-max-concurrent-analyses!
-- Toggles the maximum number of analyses we will run in parallel.
UPDATE concurrent_analysis_scheduling
SET concurrent_analyses = :concurrent_analyses;

-- name: update-active-modules!
-- Specifies which modules we shall activate.
UPDATE active_modules
SET simulation = :simulation;

-- name: update-analysis-plan!
update project_analysis_configurations
       set analysisplan= :analysisplan
       where id = ?;

-- name: delete-analysis-status-by-project-id!
-- Deletes the planned analysis as identified by the project ID.
delete from analysis_status where project_id = ?;

-- name: delete-all-analysis-statuses!
delete from analysis_status;

-- name: update-analysis-status!
-- Updates the analysis status for the given project. NOTE: the timestamp is applied by the DB.
update analysis_status
       set status = :status, 
           last_status_change = CURRENT_TIMESTAMP(),
           analysis_path = :analysis_path
       where project_id = ?;

-- name: analysis-by-status
-- Returns all analysis statuses that matches the given status.
select id, status, last_status_change, project_id, analysis_path from analysis_status
       where status = ?;
