-- name: insert-license<!
-- Inserts new license key while returning its ID
INSERT INTO license_keys
       (valid, license_key)
       VALUES(:valid, :license_key);

-- name: invalidate-license!
-- Invalidates existing license, typically because license server reported it as :invalid.
UPDATE license_keys SET valid = FALSE

-- name: make-license-valid!
-- Marks existing license as valid, typically because license server reported it as :valid.
UPDATE license_keys SET valid = TRUE

-- name: current-license-data
-- Returns the data about the current license if any.
-- Notice that we just return license_data_signature instead of complete data.
-- That's because other columns in license_data table are only informative and can be tampered.
-- Application should always verify the license_data_signature and decode license data from it
SELECT l.id, l.license_key, l.valid, ld.license_data_signature
FROM license_keys l JOIN license_data ld ON l.id = ld.license_id

-- name: insert-license-data!
-- Inserts details about license like authors count, etc.
INSERT INTO license_data
(license_id, username, authors, end_date, license_data_signature)
VALUES (:license_id, :username, :authors, :end_date, :license_data_signature);

-- name: get-license-data
-- retrieve license data by given license id
SELECT * FROM license_data
WHERE license_id = :license_id;

-- name: update-license-data!
-- updates the timestamp of last license check
UPDATE license_data
SET authors = :authors, username = :username, end_date = :end_date,
  license_data_signature = :license_data_signature
WHERE license_id IN (SELECT id FROM license_keys WHERE license_key = :license_key);

-- name: delete-license-data!
DELETE FROM license_data;

-- name: delete-license-keys!
DELETE FROM license_keys;

-- name: insert-license-check!
INSERT INTO license_checks (validation_result, validation_message, checked_at)
       VALUES(:validation_result, :validation_message, :checked_at);

-- name: get-instance-data
SELECT instance_id, installation_date FROM instance_data;
