// @flow
import $ from 'jquery';

import * as xhr from 'codescene-ui/src/browser/xhr';
import * as alerts from 'codescene-ui/src/alerts';

import * as commitRiskTable from './commit-risk-table';

type ViewOptions = {
  commitWarningsUrl : string,
  projectId: number,
  analysisId: number
};

export function init(options : ViewOptions) {
  const container = $('#tableview');
  const progressBar = alerts.progress(container, 'Loading commits...');

  xhr.csv(options.commitWarningsUrl)
    .then(commits => {
      var commitRisks = commitRiskTable.renderTable(commits, options.projectId, options.analysisId);
      container.html(commitRisks);
    })
    .catch(e => {
      console.error(e);
      alerts.error(container, 'Failed to load commits.');
    })
    .then(() => {
      progressBar.remove();
    });
}
