
-- name: select-principals-by-user
select name
       from user_principals
       where user_id = :id

-- name: select-user-by-id
select uwp.name, uwp.provider, up.name as principal
from user_principals up join users_with_principals uwp on (up.user_id = uwp.id)
where user_id = :id


-- name: select-principals
select up.name, uwp.provider
from user_principals as up
join users_with_principals as uwp
  on uwp.id = up.user_id

-- name: delete-principals-by-user!
delete from user_principals
       where user_id = :id

-- name: insert-user<!
insert into users_with_principals
       (name, provider)
       values
       (:name, :provider)

-- name: delete-user!
delete from users_with_principals
       where id = :id

-- name: delete-users!
delete from users_with_principals
  
-- name: update-provider!
update users_with_principals
       set provider = :provider
       where id = :id

-- name: update-last-login-timestamp!
update users_with_principals
       set last_login = CURRENT_TIMESTAMP()
       where id = :id

-- name: insert-user-principal<!
insert into user_principals
       (user_id, name)
       values
       (:user_id, :name)

-- name: select-users
select id, name, provider
       from users_with_principals

-- name: select-users-by-provider
select id, name
       from users_with_principals
       where provider = :provider

-- name: select-users-without-provider
select id, name
       from users_with_principals
       where provider is NULL
