(ns codescene.features.reports.portfolio.four-factor-info
  (:require
   [codescene.features.reports.common.pdf-elements :as pdf-elements]
   [codescene.features.reports.common.styling :as styling]
   [codescene.features.reports.pdf-helpers :as ph]))


(defn- info-cell [title text icon dark?]
  (let [cell-colors (if dark? :ffi-dark-cell :ffi-light-cell)
        text-colors (if dark? :ffi-dark-text :ffi-light-text)]
    (ph/cell [:ffi-info-cell cell-colors]
             (ph/image [:ffi-icon-image] icon)
             (ph/paragraph [:ffi-info-title-paragraph text-colors] title)
             (ph/paragraph [:ffi-info-text-paragraph text-colors] text))))


(defn pdf-element [{:keys [img-dir four-factor-docs-url]}]
  (let [icon-1 (styling/load-resource img-dir "portfolio/circle-1.png")
        icon-2 (styling/load-resource img-dir "portfolio/circle-2.png")
        icon-3 (styling/load-resource img-dir "portfolio/circle-3.png")
        icon-4 (styling/load-resource img-dir "portfolio/circle-4.png")]
    (ph/table [:ffi-top-table] nil
              (ph/row (ph/cell []
                               (ph/paragraph [:ffi-heading-paragraph] "From Code to Delivery: The 4 Factors Model")
                               (ph/paragraph [:ffi-headtext-paragraph1] "Modern software development is an intricate coordination between people, code and the business.")
                               (ph/paragraph [:ffi-headtext-paragraph2] "CodeScene has identified 4 factors essential to successful software development.")))
              (ph/row (ph/cell [] (ph/table [] [10 1 10 1 10 1 10]
                                            (ph/row
                                             (info-cell "Code Health"
                                                        "Healthy code that’s easy to maintain and evolve as business needs change."
                                                        icon-1 false)
                                             ""
                                             (info-cell "Knowledge Distribution"
                                                        "Distributed knowledge and high code familiarity with low risk of knowledge loss."
                                                        icon-2 false)
                                             ""
                                             (info-cell "Team-code Alignment"
                                                        "Cohesive teams with few external dependencies and low coordination needs."
                                                        icon-3 false)
                                             ""
                                             (info-cell "Delivery"
                                                        "Efficient delivery and short time-to-market is the outcome when the other three factors are healthy.   "
                                                        icon-4 true)
                                             ))))
              (ph/row (ph/cell [:ffi-link-cell] (ph/table [] [1 10] (pdf-elements/link-row four-factor-docs-url "Read more" img-dir)))))))
