(ns codescene.features.reports.common.style-def)


(def lightest-grey [247 246 245])
(def light-grey [216 216 216])
(def medium-grey [142 142 142])
(def green [13 112 93])
(def light-green [122 208 95])
(def light-red [238 138 115])
(def green-transparent [195 213 209])
(def red [254 104 73])
(def red-transparent [255 200 180])
(def yellow [213 202 0])
(def light-sky-blue [135 206 250])
(def yellow-transparent [255 255 195])
(def font-blue [55 84 145])
(def font-teal [94 213 217])
(def font-darkteal [75 170 174])
(def font-darkgrey [58 68 90])
(def font-lightgrey [98 111 139])
(def font-darkblue [22 44 83])
(def card-blue [83 133 162])
(def black [0 0 0])
(def white [255 255 255])
(def dark-grey [77 77 77])
(def title-page-list-title-color [207 215 231])
(def content-page-border-and-line-color [228 228 244])
(def healthy-color [79 159 120])
(def attention-color [241 147 103])
(def risky-color [224 82 92])
(def na-color [228 234 244])
(def pale-healthy-color [237 245 242])
(def pale-attention-color [254 244 240])
(def pale-risky-color [252 238 239])

(def no-alerts-color [242 244 248])


(def content-styles
  {:c-card-table {:width-percent 100 :spacing-before 6 :spacing-after 6}
   :c-card-narrow-table {:width-percent 100 :spacing-before 4 :spacing-after 4}
   :c-card-cell-padding {:padding 16}
   :c-card-cell-narrow-padding {:padding 10}
   :c-card-cell {:background-color white :border-color content-page-border-and-line-color}
   :c-card-content-top-table {:padding 0 :spacing-before 0 :spacing-after 0 :cell-border false}

   :c-page-header-paragraph {:size 17 :leading 15 :color font-darkblue :style :bold :spacing-after 15}
   :c-health-image {:scale 16}
   :c-trend-image {:scale 20}
   :c-miniheader {:size 9 :align :left :color font-darkteal}
   :c-subheader {:size 8 :color font-darkgrey}
   :c-border-healthy {:border-color healthy-color}
   :c-border-attention {:border-color attention-color}
   :c-border-risky {:border-color risky-color}
   :c-border-na {:border-color na-color}
   :c-border-suppressed {:border-color font-lightgrey}
   :c-line {:color content-page-border-and-line-color}
   :c-dotted-line {:dotted true :color content-page-border-and-line-color :gap 2}
   :c-dot-cell {:valign :middle :align :right :padding 0}
   :c-image-dot {:scale 1.2}
   :c-dot-legend-cell {:valign :middle :align :left :padding 0}
   :c-dot-legend-paragraph {:size 8 :color font-darkgrey}

   :c-link-text-phrase {:size 10}
   :c-link-text-cell {:valign :middle :align :right :padding 0}
   :c-link-image {:scale 3}
   :c-link-image-cell {:valign :middle :align :left :padding 0}
   :c-link-small-text-phrase {:size 8 :style :underline}
   :c-link-small-image {:scale 2}

   :c-leftborder-cell {:set-border [:left] :border-width 1.3 :padding [0 0 0 10] :valign :middle :align :left}

   :c-factor-cell {:set-border [:left] :border-width 1.3 :padding [1 1 1 4]}
   :c-factor-subheader-cell {:valign :top :padding [1 1 3 1]}
   :c-factor-subheader-paragraph {:size 9 :align :left :valign :middle :color black}
   :c-factor-contents-cell {:valign :middle :padding [3 1 1 1]}
   :c-factor-small-cell {:padding 0}
   :c-factor-small-subheader-cell {:valign :top :padding [1 1 3 1]}
   :c-factor-small-subheader-paragraph {:size 8 :align :left :valign :middle :color font-darkgrey}
   :c-factor-small-trend-paragraph {:size 6 :color font-lightgrey}
   :c-factor-small-contents-cell {:valign :middle :padding [3 1 1 1]}
   :c-factor-small-trend-image {:scale 15}
   :c-factor-small-image {:scale 13}

   :glo-top-table {:width-percent 100 :padding [0 0 0 0] :background-color white :cell-border false}
   :glo-title-paragraph {:size 10 :style :bold :color font-darkblue :spacing-before 0 :spacing-after 4}
   :glo-text-paragraph {:size 10 :color font-lightgrey :leading 12 :spacing-after 10}
   :glo-image {:scale 7}
   :glo-image-table {:padding [5 0 7 0]}
   })

(def code-health-report-styles
  {:code-health-title-page-table {:width-percent 100 :spacing-before 10 :spacing-after 10}
   :code-health-title-page-cell {:background-color card-blue :padding 20 :border false}

   :blue-cell {:background-color font-teal}
   :yellow-cell {:background-color yellow}

   :och-cell {:set-border [:top :bottom :left :right] :border-color light-grey}
   :och-table {:padding 10 :spacing-before 0 :spacing-after 0 :cell-border false}
   :och-line-cell {:padding [0 10 5 10]}
   :och-nopadding-table {:padding 0}
   :och-title {:size 9 :align :left :valign :middle :color black}
   :och-graphics-table {:bounding-box [35 35] :cell-border true}
   :och-graphics-cell {:valign :bottom :align :right :height 30}

   :cho-righthand-table {:padding [0 0 0 10] :spacing-before 0 :spacing-after 0 :cell-border false}
   :cho-project-name {:size 18 :color font-darkgrey :leading 22}
   :cho-graphics-table {:bounding-box [80 80] :cell-border true}
   :cho-graphics-cell {:valign :bottom :align :left :height 68}
   :cho-tip-cell {:valign :middle :align :center}
   :cho-righthand-cell {:padding [0 4 4 16]}

   :prs-righthand-table {:padding [4 1 4 4]}
   :prs-righthand-cell {:valign :middle :align :center :padding [5 0 0 20]}
   :prs-line-cell {:padding [0 0 0 0]}
   :prs-paragraph-large {:size 12 :color font-darkgrey}
   :prs-paragraph-small {:size 8 :color font-lightgrey}
   :prs-graphics-table {:padding 0}
   :prs-graph-cell {:valign :middle :align :left}
   :prs-graphics-cell {:valign :bottom :align :left :height 100}
   :prs-empty-image {:scale 10}
   :prs-empty-righthand-cell {:valign :top :padding 0}
   :prs-empty-title-paragraph {:size 14 :spacing-after 5}
   :prs-empty-description-paragraph {:size 10 :color font-lightgrey}

   :tta-alert-cell {:background-color pale-risky-color :padding 16 :border false}
   :tta-na-cell {:background-color no-alerts-color :padding 5 :border false :height 75}
   :tta-na-image {:scale 8}
   :tta-na-text-paragraph {:size 12 :color font-darkgrey}
   :tta-na-image-cell {:padding 10 :valign :middle :align :center}
   :tta-na-text-cell {:padding 5 :valign :middle :align :left}
   :tta-image {:scale 24}
   :tta-text-cell {:padding 0 :valign :top :align :left :height 30}
   :tta-single-text-cell {:padding 0 :valign :middle :align :left :height 45}
   :tta-text-paragraph {:size 8 :color font-darkgrey}
   :tta-link-cell {:padding 0 :valign :bottom :align :left}
   :tta-single-link-cell {:padding 0 :valign :middle :align :right}
   :tta-description-cell {:padding 10 :valign :middle :align :center}

   :act-link-cell {:align :right :valign :middle}
   :act-link-image-cell {:align :right :valign :middle}
   :act-graphics-surrounding-cell {:padding [0 0 0 0]}
   :act-graphics-table {:padding 0 :bounding-box [300 150] :cell-border false}
   :act-graphics-cell {:padding [0 0 0 0] :valign :bottom :align :left :height 140}
   :act-empty-graphics-table {:padding 0 :bounding-box [300 150] :background-color lightest-grey :cell-border false}
   :act-empty-graphics-cell1 {:padding [0 0 4 0] :valign :bottom :align :center :height 70}
   :act-empty-graphics-cell2 {:padding [4 0 0 0] :valign :top :align :center :height 70}
   :act-empty-image {:scale 7}

   :mss-icon-image {:scale 5.5}
   :mss-icon-cell {:valign :middle :align :left}
   :mss-title-cell {:height 16 :valign :top :align :left}
   :mss-title-paragraph {:size 8 :color font-lightgrey}
   :mss-number-cell {:valign :middle :align :left}
   :mss-number-paragraph {:size 16 :color font-darkgrey}
   :mss-changeicon-image {:scale 2}
   :mss-changeicon-cell {:padding 0 :valign :middle :align :right}
   :mss-changetext-paragraph {:size 8 :color font-lightgrey}
   :mss-changetext-cell {:valign :middle :align :left}
   :mss-description-paragraph {:size 6 :color font-lightgrey}
   :mss-cell {:valign :bottom :align :left :padding 0}

   :cr-diagram-cell {:valign :middle :align :left}
   :cr-diagram-image {:scale 25}
   :cr-text-cell {:valign :top :align :left :padding [0 5 0 0]}
   :cr-title-paragraph {:size 12}
   :cr-text-paragraph {:size 8 :color dark-grey}

   :with-borders {:set-border [:top :bottom :left :right] :border-color font-blue}
   })

(def portfolio-report-styles
  {:pf-heading {:style :bold :size 18 :color black}
   :pf-body {:size 11 :color black}

   :aps-cell {:valign :bottom :align :left :padding 0}
   :aps-icon-cell {:valign :middle :align :left}
   :aps-icon-image {:scale 5.5}
   :aps-title-cell {:height 16 :valign :top :align :left}
   :aps-title-paragraph {:size 8 :color font-lightgrey}
   :aps-number-paragraph {:size 16 :color font-darkgrey}

   :ffi-heading-paragraph {:color font-darkblue :size 18 :style :bold :leading 18 :spacing-before 0 :spacing-after 10}
   :ffi-headtext-paragraph1 {:color font-lightgrey :size 10 :leading 10}
   :ffi-headtext-paragraph2 {:color font-lightgrey :size 10 :leading 10 :spacing-after 16}
   :ffi-top-table {:padding 0 :cell-border false :width-percent 100}
   :ffi-info-cell {:set-border [:top :bottom :left :right] :align :left :valign :top :padding 16}
   :ffi-info-title-paragraph {:style :bold :size 8 :leading 8 :spacing-before 12 :spacing-after 8}
   :ffi-info-text-paragraph {:size 9 :leading 10 :spacing-before 0 :spacing-after 0}
   :ffi-light-cell {:border-color na-color}
   :ffi-light-text {:color font-darkgrey}
   :ffi-dark-cell {:background-color font-darkblue :border-color title-page-list-title-color}
   :ffi-dark-text {:color white}
   :ffi-icon-image {:scale 4}
   :ffi-link-cell {:padding [8 0 8 0]}

   :so-link-cell {:align :right :valign :middle}
   :so-factor-title-paragraph {:size 12 :color font-darkgrey}
   :so-graphics-table {:bounding-box [90 90] :cell-border true}
   :so-graphics-cell {:valign :bottom :align :left :height 57}
   :so-lefthand-cell {:padding [0 4 4 0]}
   :so-righthand-cell {:padding [0 4 4 16]}
   :so-line-cell {:padding [4 0 16 0]}
   :so-info-table {:spacing-before 5}
   :so-info-icon {:scale 2}
   :so-info-text {:size 7 :color font-darkgrey}
   :so-info-cell {:align :left :valign :middle :padding 0}
   :so-number-paragraph {:size 10 :color font-darkgrey :style :bold}
   :so-changeicon-image {:scale 2}
   :so-changetext-paragraph {:size 7 :color font-lightgrey}
   :so-na-line-cell {:padding [4 0 11 0]}
   :so-na-image {:scale 13}
   :so-na-righthand-cell {:padding [0 0 0 16]}
   :so-na-table {:padding 0}
   :so-na-info-text {:size 10 :color font-lightgrey :leading 10 :spacing-before 6 :spacing-after 6}

   :pc-left-cell {:padding [0 10 0 0]}
   :pc-title-cell {:padding [0 0 10 0]}
   :pc-stats-cell {:padding [2 0 2 0]}
   :pc-line-cell {:padding [2 0 12 0]}
   :pc-title-phrase {:styles [:bold :underline] :size 12 :leading 12 :color font-darkblue}
   :pc-rp-cell {:background-color pale-healthy-color :padding 10}
   :pc-rp-title-paragraph {:size 6 :style :bold :spacing-after 4 :leading 6 :color font-darkgrey}
   :pc-rp-text-paragraph {:leading 10}
   :pc-rp-text-phrase {:size 8 :color font-darkblue}
   :pc-rp-number-phrase {:size 8 :style :bold :color font-lightgrey}
   :pc-rp-link-table {:spacing-before 0 :spacing-after 4}
   :pc-rp-light-chunk {:size 8 :color font-darkblue}
   :pc-rp-heavy-chunk {:size 8 :color font-lightgrey :style :bold}
   :pc-rp-stats-cell {:padding 0 :align :left :valign :middle}
   :pc-rp-stats-paragraph {:size 8}
   :pc-rp-stats-image {:scale 2}
   :pc-rp-dot-cell {:padding 0 :align :center :valign :middle}
   :pc-rp-dot-image {:scale 0.5}
   :pc-rp-na-cell {:padding 10 :border-color na-color :set-border [:top :bottom :left :right]}
   :pc-rp-na-image {:scale 2.5}
   :pc-rp-na-link-table {:spacing-before 4 :spacing-after 4}
   :pc-rp-na-text-paragraph {:size 9 :color font-lightgrey :leading 10 :spacing-before 0 :spacing-after 0}
   })

(def title-page-styles
  {:ch-tp-title-paragraph {:size 40 :align :left :color white :leading 50 :indent-right 200}
   :pf-tp-title-paragraph {:size 40 :align :left :color white :leading 50}
   :tp-subtitle-paragraph {:size 24 :align :left :color white :leading 35 :style :bold}
   :tp-subtitle-cell {:height 35 :padding 0}
   :tp-top-table {:padding [0 20 0 20] :cell-border false :width-percent 100}
   :tp-footer1 {:size 12 :align :left :color white}
   :tp-footer2 {:size 10 :align :left :color title-page-list-title-color}
   :tp-miniheader {:size 11 :align :left :color font-teal}
   :tp-separation-line {:color card-blue}
   :tp-list-table {:width-percent 100 :padding [0 0 0 0]}
   :tp-list-cell {:border false :padding [10 0 10 0]}
   :tp-list-image-cell {:align :left :valign :middle}
   :tp-list-image {:scale 25}
   :tp-list-title-cell {:align :left :valign :bottom :padding [0 0 10 0]}
   :tp-list-title {:size 11 :color title-page-list-title-color}
   :tp-list-text-cell {:align :left :valign :top :padding [10 0 0 0]}
   :tp-list-text {:style :bold :size 24 :color white}})

(def layout-styles
  {:no-left-indent {:indent-left 0}
   :left-indent {:indent-left 20}})

(def stylesheet
  (merge
   content-styles
   title-page-styles
   portfolio-report-styles
   code-health-report-styles
   layout-styles))

(def pdf-report-metadata
  {:title "CodeScene Status Report"
   :left-margin 20
   :right-margin 20
   :top-margin 65
   :bottom-margin 10
   :subject "Report"
   :size :a4
   :font {:family "helvetica"}
   :author "CodeScene"
   :creator "CodeScene"
   :doc-header ["CodeScene Status Report"]
   :header nil
   :footer false
   :pages false
   :stylesheet stylesheet})
