-- :name select-kv :? :*
SELECT * FROM project_delta_config_kv WHERE project_id = :project_id;

-- :name update-kv! :! :n
update project_delta_config_kv SET setting_value = :setting_value WHERE project_id = :project_id and setting_key = :setting_key;

-- :name insert-kv! :insert
insert into project_delta_config_kv(project_id, setting_key, setting_value) values (:project_id, :setting_key, :setting_value);

-- :name delete-key! :! :n
delete from project_delta_config_kv where project_id = :project_id AND setting_key = :setting_key

-- :name elsewhere-ch-enabled-repos :? :*
select pr.url as repo_url
from project_repositories pr
         join projects p on pr.project_id = p.id
         join project_delta_config pdc on pdc.project_id = p.id
where url in (select url from project_repositories where project_id = :project_id)
  and p.status = 'created' and p.id != :project_id and pdc.ch_enabled = true;

-- :name elsewhere-cov-enabled-repos :? :*
select pr.url as repo_url
from project_repositories pr
         join projects p on pr.project_id = p.id
         join project_delta_config pdc on pdc.project_id = p.id
where url in (select url from project_repositories where project_id = :project_id)
  and p.status = 'created' and p.id != :project_id and pdc.cov_enabled = true;

-- :name select-by-project-id :? :1
select * from project_delta_config where project_id = :project_id;

-- :name select-all :? :*
select pdc.project_id, pdc.ch_enabled, pdc.cov_enabled
from project_delta_config pdc
--~ (when (:account_id params) " join projects p on (pdc.project_id = p.id)")
where 1 = 1
/*~ (when (and (:account_id params) (:collaborator_user_id params)) */
    and (p.owner_id = :account_id
        OR
        p.id IN (SELECT project_id
                 FROM project_collaborators pc
                 WHERE pc.user_id = :collaborator_user_id))
/*~ ) ~*/
;

-- :name insert-core! :insert
insert into project_delta_config (project_id, ch_enabled, cov_enabled, provider_id)
values (:project_id,
--~ (if (contains? params :ch_enabled) ":ch_enabled, " "false,")
--~ (if (contains? params :cov_enabled) ":cov_enabled," "false,")
--~ (if (:provider_id params) " :provider_id" "'none'")
        )

-- :name update-core! :! :n
update project_delta_config set
    project_id = project_id
--~ (when (contains? params :ch_enabled) ", ch_enabled = :ch_enabled")
--~ (when (contains? params :cov_enabled) ", cov_enabled = :cov_enabled")
--~ (when (contains? params :provider_id) ", provider_id = :provider_id")
WHERE project_id = :project_id

-- :name project-github-app-ids :? :*
SELECT pdckv.setting_value
FROM project_delta_config_kv pdckv join project_delta_config pdc on (pdckv.project_id = pdc.project_id)
WHERE pdc.provider_id = 'github' AND (pdc.ch_enabled = true or pdc.cov_enabled = true) AND pdckv.setting_key = 'app-id'

-- :name preset-git-hub-app-ids :? :*
SELECT SKV.setting_value
FROM settings_kv SKV JOIN settings S
WHERE S.ID = SKV.settings_id AND S.active = true AND S.category = 'pr-github-app' AND SKV.setting_key = 'app-id'

-- :name select-by-provider :? :*
SELECT pdc.ch_enabled, pdc.cov_enabled, pdc.provider_id, pdckv.* from
project_delta_config_kv pdckv join project_delta_config pdc on pdckv.project_id = pdc.project_id
WHERE
    pdc.provider_id = :provider_id