lexer grammar VisualBasicSharedRulesLexer;

fragment ESCAPED_QUOTE : '""';
LITERAL : '"' ( ESCAPED_QUOTE | ~'"')*? '"';

SINGLE_LITERAL : '\''  ~('\n'|'\r')*? '\'';

LITERAL_CHAR : '\'' . '\'' -> skip;

CDATE : '<![CDATA[' .*? ']]>' -> skip;

// We need to go for a case insensitive grammar since VB doesn't distinguish case.

fragment A : [aA];
fragment B : [bB];
fragment C : [cC];
fragment D : [dD];
fragment E : [eE];
fragment F : [fF];
fragment G : [gG];
fragment H : [hH];
fragment I : [iI];
fragment J : [jJ];
fragment K : [kK];
fragment L : [lL];
fragment M : [mM];
fragment N : [nN];
fragment O : [oO];
fragment P : [pP];
fragment Q : [qQ];
fragment R : [rR];
fragment S : [sS];
fragment T : [tT];
fragment U : [uU];
fragment V : [vV];
fragment W : [wW];
fragment X : [xX];
fragment Y : [yY];
fragment Z : [zZ];

AS: A S;
OF: O F;
DIM: D I M;
EACH: E A C H;

END: E N D;

CLASS: C L A S S;
END_CLASS: END [ \t]+ CLASS;

STRUCTURE: S T R U C T U R E;
END_STRUCTURE: END [ \t]+ STRUCTURE;

EXIT: E X I T;

SUB: S U B;
END_SUB: END [ \t]+ SUB;
EXIT_SUB: EXIT [ \t]+ SUB;

FUNCTION: F U N C T I O N;
END_FUNCTION: END [ \t]+ FUNCTION;
EXIT_FUNCTION: EXIT [ \t]+ FUNCTION;

OPERATOR: O P E R A T O R;
END_OPERATOR: END [ \t]+ OPERATOR;

PROPERTY: P R O P E R T Y;
END_PROPERTY: END [ \t]+ PROPERTY;
GET: G E T;
END_GET: END [ \t]+ GET;
SET: S E T;
END_SET: END [ \t]+ SET;

INTERFACE: I N T E R F A C E;
END_INTERFACE: END [ \t]+ INTERFACE;

// Complexity
THEN: T H E N;
IF: I F;
END_IF: END [ \t]+ IF;
ELSE: E L S E;

// Loops
WHILE: W H I L E;
END_WHILE: END [ \t]+ WHILE;
EXIT_WHILE: EXIT [ \t]+ WHILE;

DO: D O;
DO_WHILE: DO [ \t]+ WHILE;
LOOP: L O O P;
EXIT_DO: EXIT [ \t]+ DO;

LOOP_WHILE: LOOP [ \t]+ WHILE;
EXIT_LOOP: EXIT [ \t]+ LOOP;

UNTIL: U N T I L;
DO_UNTIL: DO [ \t]+ UNTIL;
LOOP_UNTIL: LOOP [ \t]+ UNTIL;

FOR: F O R;
EXIT_FOR: EXIT [ \t]+ FOR;

TO: T O;
STEP: S T E P;
NEXT: N E X T;

SELECT: S E L E C T;
CASE: C A S E;
SELECT_CASE: SELECT [ \t]+ CASE;
END_SELECT: END [ \t]+ SELECT;

AND: A N D;
AndAlso: AND A L S O;
OR: O R;
OrElse: OR ELSE;

RETURN: R E T U R N;

LEFT_PAREN: '(';
RIGHT_PAREN: ')';

LineComment: '\'' ~[\r\n]* -> skip;
NEWLINE : '\r'? '\n' -> skip;
Whitespace : [ \t]+ -> skip;

ID : [a-zA-Z_][a-zA-Z0-9_]*;
INTEGER: [0-9]+;
OPERATORS : '+' | '-' | '*' | '/' | '\\' | '&' | '^' |  '>>' | '<<' | '=' | '<>' | '>' | '>=' | '<' | '<=';

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence
