grammar ObjectiveCMicro;

import ObjectiveCSharedRulesParser;

translationunit
:
	expression* EOF
;

expression : cpp_function_definition
           | pre_proc_top_level_start
           | using_namespace
           | namespace_block
           | extern_c_block
           | class_declaration
           | specta_bdd_test_context
           | block_statement
           | anything;

using_namespace : 'using' NAMESPACE ID ';';
namespace_block : NAMESPACE ID? LeftBrace expression* RightBrace;

extern_c_block : EXTERN_C expression* RightBrace;

class_declaration : (CLASS | STRUCT) class_name ~(';' | LeftBrace)*? LeftBrace expression* RightBrace
                  | IMPLEMENTATION_START class_name objective_c_expression* IMPLEMENTATION_END;
class_name : ID;


