grammar CSharpCohesion;

import CSharpSharedRulesParser;

translationunit
:
	expression* EOF
;

expression : pre_proc_top_level_start
           | namespace_block
           | class_declaration
           | block_statement
           | anything;

// We only want a possible variable once we know that we're inside a class.
class_declaration : (CLASS | STRUCT) class_name ~(';')*? LeftBrace inside_class_expression* RightBrace;

inside_class_expression : variable_field
                        | property_accessor
                        | property_with_object_initialization
                        | function_declaration
                        | block_statement
                        | anything;

variable_field: variable_name (';' | property_with_object_initialization | '=');
variable_name: ID;

accessor_rule: PRIVATE | PUBLIC | INTERNAL;

property_accessor: variable_name LeftBrace accessor_rule? ('get' | 'set') inside_object_initialization+ RightBrace;

property_with_object_initialization : '=' 'new'  ID LeftParen function_definition_params_list? RightParen LeftBrace inside_object_initialization+ RightBrace;

inside_object_initialization : block_statement
                             | anything;

// NOTE: override the function body rule here -- we do NOT want to parse local functions as
// part of the cohesion calculation. That would make the function call graph detection more complex.
// Instead, we deduce cohesion from the enclosing functions.
function_body_statement : pre_proc_block
                        | new_object_expr
                        | block_statement
                        | any_statement;

PRIVATE: 'private';
PUBLIC: 'public';
INTERNAL: 'internal';