(ns codescene.features.reports.portfolio.pdf-elements
  (:require [codescene.features.reports.pdf-helpers :as ph]
            [codescene.features.reports.common.pdf-elements :as pdf-elements]
            [codescene.features.reports.common.styling :as styling]))


(defn- org-part [account-info img-dir col-widths]
  (cond (:org-name account-info)
        (let [org-img (styling/load-resource img-dir "portfolio/organizational account.png")]
          (ph/row
           (ph/cell [:tp-list-cell] (pdf-elements/title-page-item col-widths org-img "Organization name" (:org-name account-info)))))
        (:user-name account-info)
        (let [org-img (styling/load-resource img-dir "portfolio/User.png")]
          (ph/row
           (ph/cell [:tp-list-cell] (pdf-elements/title-page-item col-widths org-img "Account user name" (:user-name account-info)))))))

(defn page-1 [{:keys [img-dir]} top-content contentlist]
  [[:svg {:under true} (styling/load-resource img-dir "contentpage-background.svg")]
   top-content
   (for [content contentlist]
     (ph/table [:c-card-table] nil (ph/row (ph/cell [:c-card-cell :c-card-cell-padding] content))))])

(defn page-2 [{:keys [img-dir]} contentlist]
  [[:svg {:under true} (styling/load-resource img-dir "contentpage-background.svg")]
   (for [content contentlist]
     (ph/table [:c-card-narrow-table] nil (ph/row (ph/cell [:c-card-cell :c-card-cell-narrow-padding] content))))])

(defn title-page-contents [account-info date-now img-dir]
  (let [formatted-generation-time (styling/instant->printable-string-with-time date-now)
        period-img (styling/load-resource img-dir "portfolio/Calendar.png")
        col-widths [1 11]]
    (ph/table
     [:tp-top-table] nil
     (ph/row
      (ph/cell
       []
       [:spacer 5]
       (ph/paragraph [:tp-miniheader] "CODESCENE REPORT")
       (ph/paragraph [:pf-tp-title-paragraph] "Software Portfolio Overview")
       [:spacer 3]
       (ph/line [:tp-separation-line])))
     (ph/row
      (ph/cell
       []
       [:spacer 4]
       (ph/table
        [:tp-list-table] nil
        (org-part account-info img-dir col-widths)
        (ph/row
         (ph/cell [:tp-list-cell] (pdf-elements/title-page-item
                                   col-widths period-img
                                   "Report generated" formatted-generation-time))))
       [:spacer 5])))))

