(ns codescene.features.pm-data.github.pr-data-provider
  (:require [codescene.features.pm-data.pr-data-provider :refer [-create PrDataProvider]]
            [codescene.features.pm-data.github.github-cache :as cache]
            [codescene.features.pm-data.github.github-fetcher :as fetcher]
            [codescene.url.url-utils :as url]))

(defn- fetch-pull-requests
  [api-client repo-url since]
  (if-let [{:keys [owner repo]} (url/github-repo-url->parts repo-url)]
    (cache/fetch-pull-requests since api-client owner repo)
    []))

(defn- validate-settings
  [{:keys [api-client] :as _provider-def} {:keys [repo-urls] :as _pr-data-context}]
  (when-let [{:keys [owner repo]} (-> repo-urls first url/github-repo-url->parts)]
    (fetcher/fetch-pull-request-count api-client owner repo)))

(defn- get-pull-requests
  [{:keys [api-client] :as _provider-def} {:keys [repo-urls] :as _pr-data-context} since]
  (->> repo-urls
       (mapcat #(fetch-pull-requests api-client % since))
       (into [])))

(deftype GitHubProvider [provider-def pr-data-context]
  PrDataProvider
  (-validate-settings [_this] (validate-settings provider-def pr-data-context))
  (-get-pull-requests [_this since] (get-pull-requests provider-def pr-data-context since)))

(defmethod -create "github"
  [provider-def pr-data-context]
  (->GitHubProvider provider-def pr-data-context))

(comment
  (def api-client {:api-client (System/getenv "GITHUB_TOKEN")})
  (def context {:repo-urls ["https://github.com/dakrone/clj-http.git"]})
  (def context {:repo-urls ["git@github.com:empear-analytics/analysis-target.git"]})
  (validate-settings api-client context)
  (get-pull-requests api-client context nil))