(ns codescene.features.plugins.meta-inf
  "Provides methods for getting data from meta-inf"
  (:require [taoensso.timbre :as log])
  (:import [java.net URL]
           [java.util.jar Manifest]))

(defn file-url [cls file-name]
  (when-let [loc (-> cls .getProtectionDomain .getCodeSource .getLocation)]
    (->> (format "jar:%s!/META-INF/%s" loc file-name)
         URL.)))

(defn- ->str-to-str-map [m]
  (->> m
       (map (fn [[k v]] [(.toString k) (.toString v)]))
       (into {})))

(defn attributes [cls]
  (try
    (when-let [url (file-url cls "MANIFEST.MF")]
      (->> url
           .openStream Manifest. .getMainAttributes
           ->str-to-str-map))
    (catch Exception e
      (let [msg (format "Failed to get manifest attributes for %s" (.getName cls))]
        (log/error msg e)))))

(defn attribute-value [cls name]
  (-> cls attributes (get name)))

(defn file-contents [cls file-name]
  (try
    (-> (file-url cls file-name) slurp)
    (catch Exception e
      (let [msg (format "Failed to get meta-inf file %s for %s" file-name (.getName cls))]
        (log/error msg e)))))

(comment
  (def plugin-cls com.codescene.plugin.SystemMapExtensionPoint)
  (file-contents plugin-cls "codescene-plugin.version")
  (attributes plugin-cls)
  (attribute-value plugin-cls "Manifest-Version"))
