(ns codescene.features.api.routes.cli
  (:require
    [codescene.features.api.core :as api-core]
    [codescene.features.api.privileges :as api-privileges]
    [codescene.features.components.auth :as auth]
    [codescene.features.tools.licensing :as licensing]
    [codescene.util.http :as http]
    [compojure.api.sweet :refer [context POST]]
    [taoensso.timbre :as log])
  (:import (clojure.lang ExceptionInfo)))

(defn- log-cli-authorize
  "Logs the fingerprint of the authorize request"
  [{:keys [body-params system] :as req}]
  (auth/mark-feature-use (api-core/api-auth system) req "cli-authorize" nil)
  (log/infof "authorize: %s" body-params)
  {:status 200})

(defn sub-routes [system]
  (context "/cli" []
    :middleware [#(api-core/wrap-authorize-any system % #{api-privileges/cli-access})]
    (POST "/authorize" request (log-cli-authorize request))))

(defn cli-license [{:keys [body-params system headers] :as req}]
  (log/infof "cli-license: %s" body-params)
  (auth/mark-feature-use (api-core/api-auth system) req "cli-license" (get headers "user-agent"))
  (let [user (auth/user (api-core/api-auth system) req)
        provider (api-core/api-licensing system)
        response (try
                   (http/response (licensing/cli-license provider user))
                   (catch ExceptionInfo e
                     (http/response (str "License unavailable: " (ex-message e)) 403)))]
    (http/plaintext-response response)))

(defn licensing-routes []
  (context "/tool-license" req
    :middleware [#(api-core/wrap-authorize-any (:system req) % #{api-privileges/cli-access api-privileges/restapi-read})]
    (POST "/cli" request (cli-license request))))