// @flow
import $ from 'jquery';

import * as OffboardingSimulation from 'codescene-ui/src/simulations/offboarding/offboarding-simulation.jsx';


export type OffboardingOptions = {
  systemmapUrl: string,
  fractalsUrl: string,
  lostAuthorsUrl: string,
  codeMarkersUrl: string,
  analysisVersion: string,
  projectId: string,
};

export function init(options:OffboardingOptions):void {
  const mapContainer:$ = $('#system-map-container');
  OffboardingSimulation.init(
    mapContainer,
    options.systemmapUrl,
    options.fractalsUrl,
    options.lostAuthorsUrl,
    options.codeMarkersUrl,
    options.analysisVersion,
    Number.parseInt(options.projectId),
  );
}
