// This is the ECMA script grammar with additions necessary to parse TypeScript too.
// We've chosen to combine these two grammars since TypeScript is a strict superset of ECMA.

grammar VisualBasic;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}
import VisualBasicSharedRulesLexer;

translationunit
:
	expression* EOF
;

expression : class_declaration
           | structure_declaration
           | function_declaration
           | anything;

interface_declaration: INTERFACE .+? END_INTERFACE;

class_declaration: CLASS class_name class_expression*? END_CLASS;

class_expression : class_declaration
                 | structure_declaration
                 | function_declaration
                 | instance_variables
                 | anything;

// Used to calculate LCOM4:
instance_variables: simple_property | instance_variable;
simple_property: PROPERTY instance_variable_name AS parameter_type;
instance_variable: DIM instance_variable_list AS;
instance_variable_list : instance_variable_name
                       | instance_variable_list ',' instance_variable_name;
instance_variable_name: ID;

structure_declaration: STRUCTURE class_name expression*? END_STRUCTURE;

class_name: ID;

anything : ~(CLASS | INTERFACE | END_CLASS | END_FUNCTION | END_SUB | END_OPERATOR | END_PROPERTY);

function_declaration : SUB function_name function_scope END_SUB
                     | FUNCTION function_name function_scope END_FUNCTION
                     | OPERATOR function_name function_scope END_OPERATOR
                     | PROPERTY function_name property_scope END_PROPERTY;

property_scope: (LEFT_PAREN RIGHT_PAREN)? AS property_type_declaration property_parts;
property_type_declaration: ~(GET | SET | END_PROPERTY | SUB | PROPERTY | AS | 'Public' | END)+?;
property_parts: (getter | setter)+;
getter: GET function_body END_GET;
setter: SET function_scope END_SET;

function_name: ID | OPERATORS | AndAlso | AND | OrElse | OR;

function_scope: generic_spec? function_parameters function_body;

generic_spec: LEFT_PAREN generic_arg RIGHT_PAREN;
generic_arg: OF plain_parameter_type generic_constraint?;
generic_constraint: AS '{' generic_constraint_list '}';
generic_constraint_list: specific_constraint
                       | generic_constraint_list ',' specific_constraint;
specific_constraint: ID | CLASS | STRUCTURE | INTERFACE;

function_parameters: LEFT_PAREN function_parameters_list? RIGHT_PAREN;

function_parameters_list: function_parameter
                         | function_parameters_list ',' function_parameter;

function_parameter: ~(AS | ',' | END_FUNCTION | END_OPERATOR | END_SUB)+? AS parameter_type default_parameter_value?;

parameter_type: plain_parameter_type initialized_by_fn_call?
              | scoped_parameter_type initialized_by_fn_call?
              | generic_parameter_type;

initialized_by_fn_call: function_parameters;
plain_parameter_type: ID;
scoped_parameter_type: plain_parameter_type
                     | scoped_parameter_type '.' plain_parameter_type;
generic_parameter_type: plain_parameter_type LEFT_PAREN OF generic_parameter_type_list RIGHT_PAREN;
generic_parameter_type_list: parameter_type
                           | generic_parameter_type_list ',' parameter_type;

default_parameter_value: '='.;

function_body : function_body_statement*?;

function_body_statement : single_lambda
                        | lambda_function
                        | lambda_sub
                        | ~(SUB | FUNCTION | PROPERTY | END_FUNCTION | END_SUB | END_OPERATOR | END_PROPERTY | END_GET | END_SET);

single_lambda: (FUNCTION | SUB) lambda_function_parameters single_lambda_body;

lambda_function_parameters: LEFT_PAREN single_line_lambda_function_parameters_list? RIGHT_PAREN;
single_line_lambda_function_parameters_list: lambda_function_parameter
                                           | single_line_lambda_function_parameters_list ',' lambda_function_parameter;

lambda_function_parameter: ID
                         | function_parameter;
single_lambda_body: lambda_expression;
lambda_expression: (ID | LEFT_PAREN | RIGHT_PAREN | ',' | '.' | OPERATORS | INTEGER | IF)+;

lambda_function: FUNCTION lambda_function_parameters  function_body_statement+? END_FUNCTION;
lambda_sub: SUB lambda_function_parameters function_body_statement+? END_SUB;
