lexer grammar GroovySharedRulesLexer;

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

LITERAL_CHAR : '\'' . '\'' -> skip;

fragment MULTI_LINE_SINGLE_QUOTE: '\'\'\'';
MULTIE_LINE_SINGLE_STRING: MULTI_LINE_SINGLE_QUOTE .*? MULTI_LINE_SINGLE_QUOTE;

fragment MULTI_LINE_SOUBLE_QUOTE: '"""';
MULTI_LINE_SOUBLE_QUOTE_STRING: MULTI_LINE_SOUBLE_QUOTE .*? MULTI_LINE_SOUBLE_QUOTE;

CLASS : 'class';
TRAIT: 'trait';
THROWS : 'throws';

LeftParen : '(';
RightParen: ')';

LeftBrace : '{';
RightBrace : '}';

SEMICOLON : ';';

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

ID : [a-zA-Z_][a-zA-Z0-9_]*;

SCOPER : '.';
SCOPED_NAME : SCOPER? ID (SCOPER ID)+;

INT : [0-9]+;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence