(ns codescene.features.util.csv
  (:require [clojure.java.io :as io]
            [semantic-csv.core :as scsv]))

(defn read-csv
  ([dir filename mappify extra-opts]
   (let [file (io/file dir filename)]
     (if (.exists file)
       (scsv/slurp-csv file (merge {:mappify mappify}
                                   extra-opts))
       [])))

  ([dir filename mappify]
   (read-csv dir filename mappify {}))

  ([dir filename]
   (read-csv dir filename true {}))

  ([source]
   (let [file (io/file source)]
     (read-csv (.getParent file)
               (.getName file)
               true
               {}))))

(defn read-csv-v2
  "Like `read-csv` but with a simplified signature and a better `remove-comments` default."
  [filename & [{:keys [mappify remove-comments]
                :or {mappify true
                     remove-comments false}
                :as options}]]
  (let [file (io/file filename)]
    (read-csv (.getParent file)
              (.getName file)
              mappify
              (assoc options
                     :mappify mappify
                     :remove-comments remove-comments))))
