(ns codescene.features.project.core)

(defprotocol ProjectConfiguration
  "Project configuration is not a snapshot object. Calling any of these functions can return different data
   on subsequent invocations"
  (-id [this] "Returns project ID")
  (-scope [this tx] "Returns a map of project scopes (e.g. the account id or group ID)")
  (-pr-integration-config [this tx] "Returns PR Integration config for the project, nil if disabled")
  (-repositories [this tx] "Returns project repositories as repo-info with :id and :branch"))
