(ns codescene.features.code-coverage.parsers.xml-utils)

(defn filter-on-tag
  [tag coll]
  (filter #(= tag (:tag %)) coll))

(defn sub-nodes
  [tag el]
  (->> (:content el)
       (filter-on-tag tag)))

(defn sub-node
  [tag el]
  (first (sub-nodes tag el)))

(defn sub-nodes-rec
  "Returns sub-elements of element `el` that match `tag`, recursively.
  Apart from triditional attributes added by clojure.data.xml,
  each element also contains `:parents` key - a vector of all the parents in the hierarchy"
  ([tag el]
   (sub-nodes-rec tag el [el]))
  ([tag el parents]
   (let [el-with-parents (cond-> el
                           (map? el) (update :content #(map (fn [e] (cond-> e
                                                                      (map? e) (update :parents (fnil conj []) el)))
                                                            %)))]
     (concat (map (fn [subnode] (assoc subnode :parents parents))
                  (sub-nodes tag el-with-parents))
             (mapcat (fn [subnode]
                       (sub-nodes-rec tag subnode (conj parents subnode)))
                     (:content el-with-parents))))))

(defn sub-nodes-in
  [el tags]
  (loop [nodes [el]
         [tag & tags-left] tags]
    (let [sub-nodes (mapcat (partial sub-nodes tag) nodes)]
      (if (empty? tags-left)
        sub-nodes
        (recur sub-nodes tags-left)))))
