// @flow
import $ from 'jquery';

import {autoGrowInputList} from '../../input-list';

function anyInputHasValue(inputs : $) {
  return inputs.filter((i, e) => $(e).val() !== '' ).length > 0;
}

export function init() {
  const container = $('.specify-paths');
  const inputList = container.find('#dynamic-vcs-list');
  const form = container.find('form');
  const continueButton = form.find('button[type=submit]');

  autoGrowInputList(inputList, {
    prefix: 'vcs_',
    placeholder: '/path/on/your/filesystem'
  });

  form.on('submit', () => {
    if (anyInputHasValue(inputList.find('input'))) {
      continueButton.html(`
      <i class="fa fa-circle-o-notch spinning"></i>
      Continuing
      `);
    }
  });
}
