grammar PHPNestedComplexity;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}

import PHPSharedRulesLexer;

method
:
	expression* EOF
;

expression : complexity
           | block_expression
           | anything;

complexity: alternate_if
          | if_clause
          | elseif_clause
          | else_clause
          | alternate_switch
          | switch_clause
          | alternate_foreach
          | for_each_loop
          | alternate_for
          | for_loop
          | alternate_while
          | while_loop
          | do_while_loop;

block_expression: LeftBrace expression*? RightBrace;

anything: ~(LeftBrace | RightBrace);

if_clause: IF some_condition complexity_body;
elseif_clause: ELSEIF some_condition complexity_body;
else_clause: ELSE complexity_body;

// Don't parse the individual pieces as the if-elseif-else chain would be
// hard to parse unambigious and it doesn't really matter in which of its
// clauses we are.
alternate_if: IF some_condition COLON expression*? ENDIF;

switch_clause: SWITCH some_condition multi_line_conditional_expression;
alternate_switch: SWITCH some_condition COLON expression*? ENDSWITCH;

multi_line_conditional_expression: LeftBrace expression*? RightBrace;
plain_line: ~LeftBrace ~(SEMICOLON)*? SEMICOLON;

for_each_loop: FOREACH LeftParen for_each_loop_part AS for_loop_condition RightParen complexity_body;
for_each_loop_part:  ~(AS | SEMICOLON | COLON)+?;

alternate_foreach: FOREACH LeftParen for_each_loop_part AS for_loop_condition RightParen COLON expression*? ENDFOREACH;

for_loop: FOR LeftParen for_loop_part SEMICOLON for_loop_part SEMICOLON for_loop_condition RightParen
               complexity_body;
alternate_for: FOR LeftParen for_loop_part SEMICOLON for_loop_part SEMICOLON for_loop_condition RightParen COLON expression*? ENDFOR;
for_loop_part: ~(SEMICOLON)*?; // each part is optional
for_loop_condition: conditions*?;

while_loop: WHILE some_condition complexity_body;
do_while_loop: DO multi_line_conditional_expression WHILE some_condition;

alternate_while: WHILE some_condition COLON expression*? ENDWHILE;

complexity_body: multi_line_conditional_expression | plain_line;

some_condition: LeftParen conditions+? RightParen;
conditions : conditional_operator
           | ~(LeftParen | RightParen | SEMICOLON)
           | LeftParen conditions*? RightParen;

conditional_operator: OPERATORS;
