lexer grammar KotlinSharedRulesLexer;

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

fragment MULTI_LINE_STRING_DELIMITER: '"""';
MULTI_LINE_STRING: MULTI_LINE_STRING_DELIMITER .*? MULTI_LINE_STRING_DELIMITER;

BACKTICKED: '`' ~'`'*? '`';

LITERAL_CHAR : '\'' . '\'';

FUNCTION: 'fun';
CLASS: 'class';
DATA : 'data';
OBJECT: 'object';

// Complexity elements
IF: 'if';
ELSE: 'else';
FOR: 'for';
FOREACH: 'forEach';
WHILE: 'while';
DO: 'do';
WHEN: 'when';
CATCH: 'catch';
THROW: 'throw';
RETURN: 'return';
AT: '@';
CONTINUE: 'continue';
BREAK: 'break';
AND: '&&';
OR: '||';

// Properties
VAL: 'val';
VAR: 'var';

NULL_COALESCING: '?:';
OPERATORS: AND | OR | NULL_COALESCING;


LeftParen : '(';
RightParen: ')';

LeftBrace : '{';
RightBrace : '}';

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

COLON : ':';
SEMICOLON: ';';
QUESTION_MARK: '?';
ASTERIX: '*';

CONSTRUCTOR: 'constructor';
INIT: 'init';

ID : [a-zA-Z_][a-zA-Z0-9_]*;

GENERIC_START : '<';
GENERIC_END : '>';

INT : [0-9]+;

FLOATS: INT '.' INT;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence
