(ns codescene.features.code-coverage.parsers.utils)

(defn ->entry [covered total]
  (when (and covered total (pos? total))
    {:covered  covered
     :total    total
     :coverage (/ covered total)}))

(defn needs-detailed-line-coverage?
  "The check command triggers our PR/pipeline gates. Those gates need 
   detailed line-by-line coverage reports. Calculating those details 
   in each invokation would lead to too much coverage data being 
   transfered in each upload. Consequently, we only to the details 
   when needed.
   Encapsulate that rule here so that its easily searchable."
    [{:keys [cli-command] :as _parse-options}]
    (= "check" cli-command))
