// @flow
import { init as initView } from 'codescene-ui/src/analyses/system-health/system-health.jsx';

const mapProps = (projectId, analysisDate, scores, params, viewContext) => ({
  projectId: projectId,
  analysisId: params['analysis-id'],
  analysisEndTime: analysisDate,
  systemsData: scores.map((score) => ({
    name: score.name,
    systemMastery: score['system-mastery'],
    teamAutonomyStatus: score['team-autonomy-status'],
    health: {
      now: score['current-score'],
      lastMonth: score['month-score'],
      lastYear: score['year-score'],
    },
    averageCodeHealth: score['code-health-now-weighted-average'],
    worstPerformerCodeHealth: score['code-health-now-worst-performer'],
    numberOfCommits: score['revisions'],
  })),
  viewContext: viewContext,
  product: 'enterprise',
});

export function init(mountPoint, projectId, analysisDate, healthScores, params, viewContext) {
  initView(mountPoint, mapProps(projectId, analysisDate, healthScores, params, viewContext));
}
