// wopr.js

var userLayer = connectUsers(myConnectionProperties);

// [Refactoring: moved the data related to chess to a new chessGame.js module]

// The module contains login related functionality that forms one behaviour: all
// code is related since it either a) uses the same data, or b) calls the same functions.
export function login(newUser) {
  val authenticated = userLayer.authenticate(newUser);
  traceLoginFor(authenticated);

  return authenticated;
}

export function logout(loggedInUser) {
  return userLayer.closeSessionFor(loggedInUser);
}

function traceLogin(user) {
   // ...some code...
}

// [Refactoring: moved playChess to a new chessGame.js module
// As a result of this refactoring, the module maintains a
// single behavior where all code and data is related: high cohesion.]
