(ns codescene.features.plugins.settings-db
  "The API for storing and loading configuration settings"
  (:require [clojure.spec.alpha :as s]
            [codescene.features.plugins.specs :as specs]))

(defprotocol SettingsDb
  (-update-settings [this external-id name settings])
  (-settings-for [this external-id]))

(s/def ::settings-db #(satisfies? SettingsDb %))

(s/fdef update-settings
  :args (s/cat :this ::settings-db
               :external-id ::specs/id
               :name ::specs/name
               :settings ::specs/settings))
(defn update-settings
  "Update the stored settings for for the given external id"
  ([this external-id name settings]
   (-update-settings this external-id name settings)))

(s/fdef settings-for
  :args (s/cat :this ::settings-db
               :external-id ::specs/id)
  :ret ::specs/settings)
(defn settings-for
  "Return the settings for the given external id"
  [this external-id]
  (-settings-for this external-id))
