// @flow
import $ from 'jquery';

// new version
import * as changeCoupling from 'codescene-ui/src/analyses/change-coupling/change-coupling.jsx';
import * as singleFileChangeCoupling from 'codescene-ui/src/analyses/change-coupling/single-file-change-coupling.jsx';

type TemporalCouplingBaseViewOptions = {
  projectId: number,
  analysisId: number,
  edgeBundleUrl: string,
  couplingFilters: Array<string>,
  temporalCouplesUrl: string,
  sumOfCouplingsUrl?: string,
  supportedXRayExtensions: Array<string>,
  viewUrl: string,
  messageOnEmpty: string,
  singleElementCouplingName?: string, // we re-use the visualization for a single element in the code review context
};

export function isSupportedFor(supportedExtensions: Array<string>, fileName: string) {
  var fileExtension = fileName.substring(fileName.lastIndexOf('.'), fileName.length);
  return (supportedExtensions.indexOf(fileExtension.toLowerCase()) > -1);
}

export function initSingleFile(path: string, options: TemporalCouplingBaseViewOptions) {
  singleFileChangeCoupling.init(
    $('.temporal-coupling-view'),
    path,
    options.urls
  );
}

export function init(options: TemporalCouplingBaseViewOptions) {
  const xrayUrlBase = `/${options.projectId}/analyses/${options.analysisId}/code/temporal/by-ticket/xray?fileName=`;

  changeCoupling.init(
    $('.change-coupling-app-container'),
    {
      edgeBundle: options.edgeBundleUrl,
      temporalCouples: options.temporalCouplesUrl,
      couplingTrends: options.changeCouplingTrendsEndpoint,
      entityTeams: options.entityTeamsUrl,
      entityArchitectural: options.entityArchitecturalUrl,
      entityLanguages: options.entityLanguagesUrl,
      componentLanguages: options.componentLanguagesUrl
    },
    {
      projectId: options.projectId,
      analysisId: options.analysisId,
      temporalViewUrl: '',
      productName: 'on-prem',
      extensions: options.supportedXRayExtensions,
      couplingFilters: options.couplingFilters,
      defaultMinimumCoupling: options.defaultMinimumCoupling,
      xrayUrlFn: (path) => xrayUrlBase + encodeURIComponent(path)
    }
  );
}
