
-- name: select-providers
select id, type, active, api_url, username, password, project_id
from webhook_providers

-- name: select-providers-by-project
select id, type, active, api_url, username, password, project_id
from webhook_providers
where project_id = :project_id

-- name: select-all-active-providers
select wp.type, wp.active, wp.project_id
from webhook_providers wp
where active = true

-- name: insert-provider<!
insert into webhook_providers
    (project_id, type, active, api_url, username, password)
values (:project_id, :type, :active, :api_url, :username, :password)

-- name: update-provider-by-id!
update webhook_providers
set type =:type, active =:active, api_url =:api_url, username =:username, password =:password
where id = :id

-- name: delete-provider-by-id!
delete from webhook_providers
where id = :id

-- name: select-provider-config-by-id
select setting_key, setting_value
from webhook_providers_config
where provider_id = :provider_id

-- name: insert-provider-config-property!
-- Inserts a single key-value pair representing specifig config property for given provider
INSERT INTO webhook_providers_config (provider_id, setting_key, setting_value)
VALUES (:provider_id, :key, :value);

-- name: update-provider-config-property!
-- Updates a single key-value pair representing specifig config property for given provider
UPDATE webhook_providers_config
SET setting_value = :value
WHERE provider_id = :provider_id AND setting_key =:key;

-- name: select-webhooks
select id, type, url
from webhooks

-- name: select-webhooks-by-project
select id, type, url
from webhooks
where project_id = :project_id

-- name: select-providers-by-type
select w.id, w.type, w.active, w.api_url, w.username, w.password, w.project_id, wpc.setting_key, wpc.setting_value
from webhook_providers w left join webhook_providers_config wpc on (w.id = wpc.provider_id)
where w.type = :provider_type and w.active = true;

-- name: insert-webhook<!
insert into webhooks (project_id, type, url)
values (:project_id, :type, :url)

-- name: update-webhook-by-id!
update webhooks
set type = :type, url = :url
where id = :id

-- name: delete-webhook-by-id!
delete from webhooks
where id = :id

-- name: delete-webhook-by-url!
delete from webhooks
where url = :url AND type = :type

-- name: project-github-app-ids
SELECT WPC.SETTING_VALUE
FROM WEBHOOK_PROVIDERS WP JOIN WEBHOOK_PROVIDERS_CONFIG WPC
WHERE WP.TYPE = 'github-app' AND WP.ACTIVE = true AND WP.ID = WPC.PROVIDER_ID AND wpc.SETTING_KEY = 'app-id'

-- name: preset-git-hub-app-ids
SELECT SKV.SETTING_VALUE
FROM SETTINGS_KV SKV JOIN SETTINGS S
WHERE S.ID = SKV.SETTINGS_ID AND S.ACTIVE = true AND S.CATEGORY = 'pr-github-app' AND SKV.SETTING_KEY = 'app-id'
