### CodeScene PR Check
{% if improvements.files-improved > 0 %}{{ icons.pass }} Code Health Improved `({{ improvements.files-improved }} files improve in Code Health)`
{% endif %}
{% if qg-summary.fail|not-empty %}**Gates Failed**{% for item in qg-summary.fail %}
{{ extra-newline }}{{ icons.fail }} {{ item.gate-name }} `({{ item.desc|safe }})`{% endfor %}{% endif %}
{% if qg-summary.pass|not-empty %}
{{ extra-newline }}**Gates Passed**
{{ extra-newline }}{{ icons.pass }} {{ qg-summary.pass|length }} Quality Gates Passed{% endif %}{% if all qg-summary.pass|empty? qg-summary.fail|empty? %}
{% if qg-meta.empty-results? %}**No application code in the PR — skipped Code Health checks.**{% else %}**No quality gates enabled for this code.**{% endif %}{% endif %}

{% if result-url %}
[See analysis details in CodeScene]({{ result-url|safe }}){% endif %}
{% if qg-summary.fail|not-empty %}{% if collapsible %}<details><summary>Reason for failure</summary>{% else %}{{ extra-newline }}**Reason for failure**{% endif %}

{% for item in qg-summary.fail %}{% ifequal item.gate "refactoring-goals" %}
| {{ item.gate-name }} |
|----------------------|
{% for cause in item.causes %}| {{ cause.file-name }} |
{% endfor %}
{% else %}| {{ item.gate-name }} | Violations | Code Health Impact |         |
|-|----|-|--|
{% for cause in item.causes %}| {{ cause.file-name }} | {% if cause.provider-url|safe %}[{{ cause.violations }}]({{ cause.provider-url|safe }}){% else %}{{ cause.violations }}{% endif %} | {{ cause.code-health-impact }} | [Suppress]({{ cause.suppress-url|safe }}) |
{% endfor %}{% endifequal %}
{% endfor %}{% if collapsible %}</details>{% endif %}{% endif %}
{% if improvements.files-improved > 0 %}{% if collapsible %}<details><summary>View Improvements</summary>{% else %}{{ extra-newline }}**Improvements**{% endif %}

| File | Code Health Impact | Categories Improved |
|-|----|--|
{% for f in improvements.files %}| {{ f.file-name }} | {{ f.code-health-impact }} | {{ f.categories }} |
{% endfor %}{% if collapsible %}</details>{% endif %}
{% endif %}{% if code-owners-for-cc|not-empty %}
#### Code Owners for Critical Code
{% for code-owner in code-owners-for-cc %}* {{code-owner}}
{% endfor %}{% endif %}
{% if description-details? %}{% for b in filtered-findings %}
### **{{ b.title }}:**{% for item in b.items %}
{{ bitbucket-newline|default:""}}* {{ item.category }} {% if item.function %}**{{ item.short-file-name }}**: {{ item.function }}{% else %}**{{ item.short-file-name }}**{% endif %}{% if all include-code-health-impact? item.impact-desc %} - {{ item.impact-desc }}{% endif %}{% if item.hotspot? %} 🔥{% endif %}{% endfor %}
{% endfor %}{% endif %}{% if directives.added|not-empty %}
**Code Health Directives**
{{ extra-newline }}[{{directives.added|length}} new code health directive{% if not directives.added|length = 1 %}s{% endif %}]({{ result-url|safe }}?added-directives=true){% endif %}
{% if result.absent-changes|not-empty %}**Absence of Expected Change Pattern**
{% for f1, files in result.absent-changes %}* {{f1}} is usually changed with: {{files|join:", "}}
{% endfor %}{% endif %}
{{ bottom-hr|safe }}
{{ extra-newline }}**Quality Gate Profile:** [{{ qg-meta.qg-profile-name }}]({{ qg-config-url|safe }})
{{ extra-newline }}Want more control? [Customize Code Health rules]({{ doc-pr-page }}) or catch issues early with our [IDE extension](https://codescene.com/developer-hub) and [CLI tool]({{ doc-cli-page|safe }}).
