grammar SwiftMethodArguments;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}

singlefunctionscope
:
	expression* EOF
;

expression : function_declaration
           | anything;

anything : .;

function_declaration : FUNCTION function_name function_scope;

function_name: ~LeftParen+;

function_scope: function_signature LeftBrace function_body* RightBrace;

function_signature: function_parameters return_type?;

function_parameters: LeftParen function_parameters_list? RightParen;

function_parameters_list: function_parameter
                         | function_parameters_list ',' function_parameter;

function_parameter: label? parameter_name COLON INOUT? parameter_type parameter_postlude;

label: ID;
parameter_name: ID;
parameter_type: plain_type | array_type | hof_type;
plain_type: ID;
array_type: '[' plain_type ']';

arg_type_list: parameter_type
             | arg_type_list ',' parameter_type;

hof_type: LeftParen arg_type_list? RightParen hof_return_type;
hof_return_type: ~(',' | LeftBrace)*?;

parameter_postlude: (VARIADIC | default_value)*;

default_value: '=' ~(',' | RightBrace)*?;

return_type: ARROW  ~LeftBrace+;

function_body : anything;

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

SINGLE_LITERAL : '\''  ~('\n'|'\r')*? '\'';

BACK_QUOTED : '`'  ~('\n'|'\r')*? '`';

LITERAL_CHAR : '\'' . '\'' -> skip;

FUNCTION: 'func';
COLON: ':';
ARROW: '->';

LeftParen : '(';
RightParen: ')';

LeftBrace : '{';
RightBrace : '}';

VARIADIC: '...';
INOUT: 'inout';

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

ID : [a-zA-Z_][a-zA-Z0-9_]*;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence
