lexer grammar PerlSharedRulesLexer;

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

fragment ESCAPED_SINGLE_LITERAL: '\\\'';
SINGLE_LITERAL : '\''  (ESCAPED_SINGLE_LITERAL | ~('\n'|'\r'))*? '\'';

BACK_QUOTED : '`'  ~('\n'|'\r')*? '`';

ESCAPED_CURLY: '\\{' | '\\}';

LITERAL_CHAR : '\'' . '\'' -> skip;

SUB: 'sub';

OUR: 'our';

LeftParen : '(';
RightParen: ')';

LeftBrace : '{';
RightBrace : '}';

FOR: 'for';
FOREACH: 'foreach';
DO: 'do';
WHILE: 'while';
UNTIL: 'until';
IF: 'if';
ELSE: 'else';
ELSIF: 'elsif';
UNLESS: 'unless';
GOTO: 'goto';
SWITCH: 'switch';
CASE: 'case';
RETURN: 'return';
OPERATORS: 'and' | '&&' | 'or' | '||';

ASSIGN: '=';

// Arguments
ALL_ARGS_ALIAS: '@_';
ONE_ARG_ALIAS: '$_[' [0-9]+ ']';

REGEX_COMMENT: '?#'; // so we don't treat it as a line comment
ESCAPED_COMMENT_TOKEN: '\\#';

NON_COMMENT_TOKEN: ([a-zA-Z0-9] | '/') '#'; // e.g. m#/#

BlockComment: ('\r' | '\n') [ \t]* '=' [a-zA-Z0-9]+ .*? '=cut' -> skip;

LineComment: ('\r' | '\n' | [ \t])* '#' ~[\r\n]* -> skip;

Whitespace : [ \t]+ -> skip;

LAST_INDEX_IN_ARRAY: '$#'; // Lex separately to avoid it gets treated as a comment

NEWLINE : '\r'? '\n' -> skip;

ID : [a-zA-Z_][a-zA-Z0-9_]*;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence


