grammar GroovyConsecutiveAssertions;

singlefunctionscope
:
	expression* EOF
;

expression : assertion_blocks
           | .;

assertion_blocks: assertion_statement+;

assertion_statement: ASSERT_START ~(NEWLINE)+ NEWLINE+;

ASSERT_START: 'assert';

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

LITERAL_CHAR : '\'' . '\'' -> skip;

fragment MULTI_LINE_SINGLE_QUOTE: '\'\'\'';
MULTIE_LINE_SINGLE_STRING: MULTI_LINE_SINGLE_QUOTE .*? MULTI_LINE_SINGLE_QUOTE;

fragment MULTI_LINE_SOUBLE_QUOTE: '"""';
MULTI_LINE_SOUBLE_QUOTE_STRING: MULTI_LINE_SOUBLE_QUOTE .*? MULTI_LINE_SOUBLE_QUOTE;

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n';

ANY_CHAR: .;