grammar CSharpConsecutiveAssertions;

singlefunctionscope
:
	expression* EOF
;

expression : assertion_blocks
           | .;

assertion_blocks: assertion_statement+;

assertion_statement: ASSERT_START ~(SEMICOLON)+ SEMICOLON;

ASSERT_START: 'Assert.';
SEMICOLON : ';';

fragment VERBATIM_ESCAPE : '""';
VERBATIM_STRING : '@' '"' ( VERBATIM_ESCAPE | ~('"'))* '"';

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

LITERAL_CHAR : '\'' . '\'' -> skip;
Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

ANY_CHAR: .;