(ns codescene.features.util.coll)

(defn do-diff
  "Compares 2 colls.
  Returns map with colls :removed :updated :added, where :updated items are pairs of old->new"
  [key-fn old-coll new-coll]
  (update (reduce (fn [{:keys [removed] :as acc} new-it]
                    (if-let [[k old-it] (find removed (key-fn new-it))]
                      (cond-> (update acc :removed dissoc k)
                        (not= old-it new-it) (update :updated conj [old-it new-it]))
                      (update acc :added conj new-it)))
                  {:removed (into {} (map (juxt key-fn identity) old-coll))
                   :added []
                   :updated []}
                  new-coll)
          :removed
          (comp vec vals)))
