-- :name select-tokens-for-user :? :*
-- Returns all tokens for the user, along with providers
select ut.*,
       :sql:columns
-- uwp.name, uwp.provider
from user_tokens ut
  :sql:joins
-- join users_with_principals uwp on ut.user_id = uwp.id
where ut.user_id = :id;

-- :name select-all-tokens :? :*
-- Returns all tokens
select ut.*,
       :sql:columns
-- uwp.name, uwp.provider
from user_tokens ut
     :sql:joins
-- join users_with_principals uwp on ut.user_id = uwp.id
LIMIT :pagelen OFFSET :offset;

-- :name insert-token! :insert
-- Inserts new token
INSERT INTO user_tokens (user_id, expires_at, hashed, :i*:additional_columns)
VALUES (:user_id, :expires_at, :hashed, :v*:additional_values);

-- :name update-used-at! :! :n
-- Updates used at for a token
UPDATE user_tokens SET used_at = CURRENT_TIMESTAMP where id = :id;

-- :name delete-token! :! :n
-- Deletes a token by id
DELETE FROM user_tokens where id = :id;

-- :name delete-user-token! :! :n
-- Deletes a token while also checking the user
DELETE FROM user_tokens where id = :id and user_id = :user_id;

-- :name delete-expired-tokens! :! :n
-- Deletes all expired tokens
DELETE FROM user_tokens where expires_at < CURRENT_TIMESTAMP;