(ns codescene.features.reports.util
  (:import [java.awt Color BasicStroke]))

(defn concatv [& args]
  (->> args (apply concat) vec))

(def black [0 0 0])
(def light-grey [216 216 216])
(def medium-grey [142 142 142])

(defn awt-color [color]
  (let [[r g b] color]
    (Color. r g b)))

(defn draw-pie [g2d width height ratio]
  (let [angle (* ratio 360)
        size (min width height)
        left (max 0 (/ (- width height) 2))
        top (max 0 (/ (- height width) 2))]
    (doto g2d
      (.setColor (awt-color black))
      (.fillArc (int left) (int top) (int size) (int size) (int 90) (int angle))
      (.setColor (awt-color light-grey))
      (.fillArc (int left) (int top) (int size) (int size) (int (+ 90 angle)) (int (- 360 angle))))))

(defn draw-doughnut [g2d width height ratio {:keys [fill-color show-percentage] :or {fill-color black show-percentage true}}]
  (let [angle (* ratio 360)
        strokeWidth (float 5)
        size (min width height)
        left (max 0 (/ (- width height) 2))
        top (max 0 (/ (- height width) 2))
        text (str (int (* 100 ratio )) " %")
        metrics (.getFontMetrics g2d)]
    (if show-percentage (.drawString g2d text (int (/ (- width (.stringWidth metrics text)) 2)) (int (/ height 2))))
    (doto g2d
      (.setStroke (BasicStroke. strokeWidth BasicStroke/CAP_ROUND BasicStroke/JOIN_ROUND))
      (.setColor (awt-color light-grey))
      (.drawArc (int left) (int (- top strokeWidth)) (int size) (int size) (int 90) (int (- 360 angle)))
      (.setColor (awt-color fill-color))
      (.drawArc (int left) (int (- top strokeWidth)) (int size) (int size) (int 90) (int (* -1 angle))))))

(defn pie-fn [nilable-ratio]
  (let [ratio (or nilable-ratio 0)]
    (fn [g2d width height]
      (draw-pie g2d width height ratio))))

(defn doughnut-fn
  [nilable-ratio & [opts]]
   (let [ratio (or nilable-ratio 0)]
     (fn [g2d width height]
       (draw-doughnut g2d width height ratio opts))))
