(ns codescene.features.reports.portfolio.all-projects-summary
  (:require
   [codescene.features.reports.pdf-helpers :as ph]
   [codescene.features.reports.common.styling :as styling]))

(defn- stat-summary [title value icon]
  (let [printable-value (styling/number->printable-string-100k (or value 0))]
    (ph/table
     [] nil
     (ph/row
      (ph/table
       [] [1 3]
       (ph/row
        (ph/cell [:aps-icon-cell] (ph/image [:aps-icon-image] icon))
        (ph/cell
         []
         (ph/table
          [] nil
          (ph/row (ph/cell [:aps-title-cell] (ph/paragraph [:aps-title-paragraph] title)))
          (ph/row (ph/cell [] (ph/paragraph [:aps-number-paragraph] printable-value)))))))))))


(defn- ->project-total-loc [project-file-summary]
  (reduce + (keep :code project-file-summary)))

(defn ->total-loc [projects]
  (reduce + (map #(->project-total-loc (:file-summary %)) projects)))


(defn pdf-element [projects {:keys [active-authors] :as _account-info} {img-dir :img-dir}]
  (let [active-authors-icon (styling/load-resource img-dir "period-stats/Users.png")
        projects-count-icon (styling/load-resource img-dir "portfolio/Folder-cloud.png")
        loc-icon (styling/load-resource img-dir "portfolio/Code.png")
        total-loc (->total-loc projects)]
    (ph/table
     [:c-card-content-top-table] nil
     (ph/row
      (ph/cell
       []
       (ph/paragraph [:c-miniheader] "ALL PROJECTS SUMMARY")
       [:spacer 1]))
     (ph/row
      (ph/table
       [] [5 1 5 1 5]
       (ph/row
        (ph/cell [:aps-cell] (stat-summary "Number of projects" (count projects) projects-count-icon))
        ""
        (ph/cell [:aps-cell] (stat-summary "Total Lines of Code" total-loc loc-icon))
        ""
        (ph/cell [:aps-cell] (stat-summary "Active Authors" (count active-authors) active-authors-icon))))))))
