(ns codescene.features.reports.pdf-reports-def)

(def ^:const page-width 595)
(def ^:const page-height 842)
(def ^:const system-mastery-high 0.7)
(def ^:const system-mastery-low 0.3)
(def ^:const code-health-high 8)
(def ^:const code-health-low 3)
(def ^:const delivery-risk-high 9)
(def ^:const delivery-risk-low 7)
(def ^:const code-health-trend-high 5)
(def ^:const code-health-trend-low 2)
(def ^:const velocity-trend-high 10.0)
(def ^:const velocity-trend-medium -5.0)
(def ^:const velocity-trend-low -25.0)

(def lightest-grey [247 246 245])
(def light-grey [216 216 216])
(def medium-grey [142 142 142])
(def green [13 112 93])
(def light-green [122 208 95])
(def light-red [238 138 115])
(def green-transparent [195 213 209])
(def red [254 104 73])
(def red-transparent [255 200 180])
(def yellow [213 202 0])
(def light-sky-blue [135 206 250])
(def yellow-transparent [255 255 195])
(def font-blue [55 84 145])
(def black [0 0 0])
(def white [255 255 255])
(def dark-grey [77 77 77])

(def overall-code-health
  {:overall-code-health-table          {:background-color white :width-percent 100 :spacing-before 20 :cell-border false :padding [0 0 0 0] :valign :center :align :center}
   :overall-code-health-table-cell     {:background-color white :valign :middle :height 45 :leading 1}
   :overall-code-health-now-table-cell {:background-color white :valign :middle :rowspan 2 :border true :set-border [:top :bottom :left :right]}
   :overall-code-health-text           {:size 11 :leading 1}
   :overall-code-health-value          {:size 18 :leading 1}
   :overall-code-health-good           {:color green :border-color green}
   :overall-code-health-normal         {:color yellow :border-color yellow}
   :overall-code-health-bad            {:color red :border-color red}})

(def early-warnings
  {:early-warnings-table             {:background-color white :width-percent 100 :spacing-before 20 :cell-border false :padding [0 0 0 0] :valign :center :align :left}
   :early-warning-parent-cell        {:width-percent 100 }
   :early-warning-cell               {:width-percent 100 :height 15 :valign :middle}
   :early-warning-cell-bottom-border {:width-percent 100 :height 25 :border true :border-color black :set-border [:bottom]}
   :early-warning-category           {:size 12 :style :bold}
   :early-warning-description        {:size 11 :style :normal}
   :early-warning-link               {:style {:size 11 :style :underline}}
   :early-warning-explanation        {:size 10 :style :normal}
   :early-warning-danger             {:color red :border-color red}
   :early-warning-warning            {:color yellow :border-color yellow}
   :early-warning-info               {:color green :border-color green}})

(def system-code-health
  {:system-code-health-table               {:background-color lightest-grey :width-percent 100 :spacing-before 20 :cell-border false :padding [0 0 0 0] :valign :center}
   :system-code-health-header-cell         {:background-color white :height 45}
   :system-code-health-header              {:size 11 :spacing-after 10 :style "bold"}
   :system-code-health-name-cell           {:background-color white :height 45 :valign :middle}
   :system-code-health-name                {:size 11 :leading 5 :color black}
   :system-code-health-commits-cell        {:background-color white :height 45 :valign :middle}
   :system-code-health-commits             {:size 11 :leading 5 :color black}
   :system-code-health-team-autonomy-cell  {:background-color white :height 45 :valign :middle}
   :system-code-health-team-autonomy       {:size 11 :leading 5 :color black}
   :system-code-health-system-mastery-cell {:background-color white :height 45 :valign :middle}
   :system-code-health-system-mastery      {:size 11 :leading 5 :color black}
   :system-code-health-cell                {:background-color white :height 45 :align :center :valign :middle}
   :system-code-health                     {:size 11 :leading 5}
   :system-code-health-good                {:size 11 :leading 5 :color green}
   :system-code-health-normal              {:size 11 :leading 5 :color yellow}
   :system-code-health-bad                 {:size 11 :leading 5 :color red}
   :code-health-arrow-image                {:width 8 :heigh 8}})

(def knowledge
  {:knowledge-table                                {:background-color white :width-percent 100 :spacing-before 0 :cell-border false :padding [0 0 0 0] :valign :top}
   :component-cell                                 {:padding [10 0 10 0]}
   :knowledge-dir-name                             {:size 6 :color medium-grey :spacing-before 0 :spacing-after 0}
   :knowledge-file-name                            {:size 9 :color black :spacing-before 0 :spacing-after 0}
   :component-header                               {:padding [0 0 10 0] :style "bold"}
   :component-filename-cell                        {:padding [2 0 2 0]}
   :component-knowledge-cell                       {:size 9 :spacing-before 0 :spacing-after 0}
   :knowlegde-red-color                            {:color red}
   :knowlegde-blue-color                           {:color light-sky-blue}
   :loss-inconclusive-color                        {:color black}
   :knowledge-island-complex-code-risk-color       {:color red}
   :knowledge-island-risk-color                    {:color yellow}
   :complex-code-by-former-contributors-risk-color {:color dark-grey}
   :multiple-active-developers-risk-color          {:color black}
   :default-risk-color                             {:color black}
   :component-link                                 {:style {:size 9 :style :underline}}
   })

(def hotspots
  {:hotspots-table                                 {:width-percent 100 :spacing-before 20 :cell-border false}
   :hotspots-table-header-cell                     {:background-color white :height 25}
   :hotspot-name-cell                              {}
   :hotspot-code-health-cell                       {:align :center :valign :middle}
   :hotspot-last-code-health-cell                  {:align :center :valign :middle}
   :hotspot-details-cell                           {}
   :hotspot-comment-cell                           {}
   :hotspot-goals-cell                             {}
   :hotspots-table-header                          {:style "bold" :size 10 :color black}
   :hotspot-file-name                              {:size 9 :color black :spacing-before 0 :spacing-after 0}
   :hotspot-dir-name                               {:size 5 :color medium-grey :spacing-before 0 :spacing-after 0}
   :hotspot-code-health                            {:size 12 :leading 6 :color black}
   :hotspot-last-code-health                       {:size 12 :leading 6 :color black}
   :hotspot-details                                {:size 6 :color black :spacing-before 0 :spacing-after 0}
   :hotspot-comment                                {:size 6 :color black}
   :hotspot-goals                                  {:size 6 :color black}})

(def system-health
  {:system-health-table                            {:background-color lightest-grey :width-percent 100 :spacing-before 20 :cell-border false :padding [2 2 2 2]}
   :system-health-key-personnel-table              {}
   :system-health-code-health-table                {}
   :system-health-descriptive-data-table           {}
   :system-health-table-header-cell                {:align :center :valign :middle}
   :system-health-table-label-cell                 {:align :center :valign :middle}
   :system-health-key-personnel-image-cell         {:height 55}
   :system-health-key-personnel-cell               {:align :left :valign :middle}
   :system-health-abandoned-code-image-cell        {:height 55}
   :system-health-abandoned-code-cell              {:align :left :valign :middle}
   :system-health-code-health-table-cell           {:padding [0 40 0 40]}
   :system-health-code-health-cell                 {:align :center :valign :middle :height 45 :padding [0 0 0 0]}
   :system-health-last-code-health-table-cell      {:padding [0 55 0 55]}
   :system-health-last-code-health-cell            {:align :center :valign :middle :height 30 :padding [0 0 0 0]}
   :system-health-last-year-code-health-table-cell {:padding [0 55 0 55]}
   :system-health-last-year-code-health-cell       {:align :center :valign :middle :height 30 :padding [0 0 0 0]}
   :system-health-hotspot-logo-cell                {:height 50}
   :system-health-red-hotspot-ratio-cell           {:align :center :valign :middle}
   :system-health-red-hotspot-effort-cell          {:align :center :valign :middle}
   :system-health-defect-ratio-in-hotspots-cell    {:align :center :valign :middle}
   :system-health-table-header                     {:style "bold" :size 13 :color black}
   :system-health-table-label                      {:size 7 :leading 7 :spacing-after 3 :color black}
   :system-health-key-personnel                    {:size 12 :color black}
   :system-health-abandoned-code                   {:size 12 :color black}
   :system-health-code-health                      {:size 20 :leading 10 :color white}
   :system-health-last-code-health                 {:size 15 :leading 7 :color white}
   :system-health-last-year-code-health            {:size 15 :leading 7 :color white}
   :system-health-red-hotspot-ratio                {:size 15 :color black}
   :system-health-red-hotspot-effort               {:size 15 :color black}
   :system-health-defect-ratio-in-hotspots         {:size 15 :color black}})

(def project
  {:project-table                                  {:background-color lightest-grey :width-percent 100 :spacing-before 20 :cell-border false :padding [2 2 2 2]}
   :project-description-and-status-table           {}
   :project-data-table                             {}
   :project-health-table                           {}
   :project-main-health-table                      {}
   :project-activity-image                         {:width 10}
   :project-name-cell                              {}
   :project-commits-last-month-cell                {}
   :project-analysis-time-cell                     {}
   :project-lines-of-code-cell                     {}
   :project-active-developers-cell                 {}
   :project-system-mastery-cell                    {:align :center :valign :middle :height 30}
   :project-delivery-risk-cell                     {:align :center :valign :middle :height 30}
   :project-missed-goals-cell                      {:align :center :valign :middle :height 30}
   :project-code-health-cell                       {:align :center :valign :middle :height 45}
   :project-name                                   {:size 11 :leading 11 :spacing-after 10 :color black}
   :project-commits-last-month                     {:size 7 :leading 7 :spacing-after 5 :color medium-grey}
   :project-analysis-time                          {:size 7 :leading 7 :spacing-after 3 :color black}
   :project-lines-of-code                          {:size 7 :leading 7 :spacing-after 3 :color black}
   :project-active-developers                      {:size 7 :leading 7 :spacing-after 3 :color black}
   :project-system-mastery                         {:size 10 :leading 5 :color black}
   :project-delivery-risk                          {:size 10 :leading 5 :color black}
   :project-missed-goals                           {:size 10 :leading 5 :color black}
   :project-total-goals                            {:size 7 :color black}
   :project-code-health                            {:size 20 :leading 10 :color black}
   :project-code-health-label                      {:size 7 :color black :align :center}
   :project-table-label                            {:size 7 :leading 7 :spacing-after 3 :color medium-grey}})

(def sub-system
  {:sub-system-health-table                        {:background-color lightest-grey :width-percent 100 :spacing-before 20 :cell-border false :padding [0 0 0 0] :valign :center}
   :sub-system-spacing-cell                        {:background-color white :height 10}
   :sub-system-health-header-cell                  {:background-color white}
   :sub-system-name-cell                           {:align :left :valign :middle}
   :sub-system-team-autonomy-cell                  {:align :center :valign :middle}
   :sub-system-mastery-cell                        {:align :center :valign :middle}
   :sub-system-code-health-cell                    {:align :center :valign :middle :height 45}
   :sub-system-delivery-risk-cell                  {:align :center :valign :middle}
   :sub-system-defects-cell                        {:align :center :valign :middle}
   :sub-system-health-header                       {:size 10 :spacing-after 10 :style "bold"}
   :sub-system-name                                {:size 11 :leading 5 :color black}
   :sub-system-team-autonomy                       {:size 12 :leading 6 :color black}
   :sub-system-mastery                             {:size 15 :leading 7 :color black}
   :sub-system-code-health                         {:size 18 :leading 9 :color white}
   :sub-system-delivery-risk                       {:size 10 :leading 5 :color black}
   :sub-system-defects                             {:size 15 :leading 7 :color black}})

(def missed-goals
  {:missed-goals-table                             {:width-percent 100 :spacing-before 20}
   :missed-goals-table-header-cell                 {:background-color lightest-grey}
   :missed-goal-image-cell                         {}
   :missed-goal-name-cell                          {}
   :missed-goal-details-cell                       {}
   :missed-goals-table-header                      {:style "bold" :size 11}
   :missed-goal-file-name                          {:size 9 :color black :spacing-before 0 :spacing-after 0}
   :missed-goal-dir-name                           {:size 5 :color medium-grey :spacing-before 0 :spacing-after 0}
   :missed-goal-details                            {:size 5 :color black :spacing-before 0 :spacing-after 0}})

(def development-output
  {:development-output-table                       {:width-percent 100 :spacing-before 20 :background-color white}
   :development-output-table-label-cell            {:align :left :valign :middle :height 20 :background-color lightest-grey}
   :development-output-monthly-output-cell         {:align :left :valign :middle}
   :development-output-monthly-contribution-cell   {:align :left :valign :middle}
   :development-output-weekly-output-cell          {:align :left :valign :middle}
   :development-output-weeekly-contribution-cell   {:align :left :valign :middle}
   :development-output-table-label                 {:size 10 :leading 5 :color black :style "bold"}
   :development-output-monthly-output              {:size 9 :leading 4 :color black}
   :development-output-monthly-contribution        {:size 9 :leading 4 :color black}
   :development-output-weekly-output               {:size 9 :leading 4 :color black}
   :development-output-weeekly-contribution        {:size 9 :leading 4 :color black}})

(def value-dependent-cell-styles
  {:team-autonomy-unset-cell                       {:background-color light-grey}
   :team-autonomy-neutral-cell                     {:background-color light-grey}
   :team-autonomy-ok-cell                          {:background-color green-transparent}
   :team-autonomy-alarm-cell                       {:background-color red-transparent}

   :system-mastery-unset-cell                      {:background-color light-grey}
   :system-mastery-ok-cell                         {:background-color green-transparent}
   :system-mastery-warning-cell                    {:background-color yellow-transparent}
   :system-mastery-alarm-cell                      {:background-color red-transparent}

   :code-health-unset-cell                         {:background-color light-grey}
   :code-health-ok-cell                            {:background-color green}
   :code-health-warning-cell                       {:background-color yellow}
   :code-health-alarm-cell                         {:background-color red}

   :delivery-risk-unset-cell                       {:background-color light-grey}
   :delivery-risk-ok-cell                          {:background-color green-transparent}
   :delivery-risk-warning-cell                     {:background-color yellow-transparent}
   :delivery-risk-alarm-cell                       {:background-color red-transparent}

   :missed-goals-unset-cell                        {:background-color light-grey}
   :missed-goals-ok-cell                           {:background-color green-transparent}
   :missed-goals-alarm-cell                        {:background-color red-transparent}

   :defects-unset-cell                             {:background-color light-grey}
   :defects-neutral-cell                           {:background-color light-grey}

   :velocity-trend-neutral-cell                    {}
   :velocity-trend-ok-cell                         {:background-color light-green}
   :velocity-trend-warning-cell                    {:background-color yellow}
   :velocity-trend-alarm-cell                      {:background-color light-red}

   :hotspot-severity-ok                            {:color green}
   :hotspot-severity-warning                       {:color yellow}
   :hotspot-severity-alarm                         {:color red}})

(def generic-text-styles
  {:title                                          {:size 36 :align :center :spacing-after 60}
   :subtitle                                       {:size 24 :align :center :color [128 128 128]}
   :heading                                        {:style "bold" :size 18 :color font-blue}
   :heading2                                       {:style "bold" :size 14 :color font-blue :spacing-after 5}
   :body                                           {:size 11}})

(def stylesheet
  (merge
    generic-text-styles
    value-dependent-cell-styles
    overall-code-health
    early-warnings
    system-code-health
    hotspots
    system-health
    project
    sub-system
    missed-goals
    development-output
    knowledge))

(def pdf-report-metadata
  {:title         "CodeScene Status Report"
   :left-margin   70
   :right-margin  70
   :top-margin    75
   :bottom-margin 75
   :subject       "Report"
   :size          :a4
   :font          {:family "helvetica"}
   :author        "CodeScene"
   :creator       "CodeScene"
   :doc-header    ["CodeScene Status Report"]
   :header        nil
   :footer        false
   :pages         false
   :stylesheet    stylesheet})
