(ns codescene.features.reports.common.pdf-elements
  (:require
   [clojure.string :as str]
   [codescene.features.reports.common.style-def :as style-def]
   [codescene.features.reports.pdf-helpers :as ph]
   [codescene.features.reports.common.styling :as styling]))


(defn title-page-item [col-widths img title content]
  (ph/table
    [] col-widths
    (ph/row
      (ph/cell
        [:tp-list-image-cell]
        (ph/image [:tp-list-image] img))
      (ph/table
        [] nil
        (ph/row (ph/cell [:tp-list-title-cell] (ph/paragraph [:tp-list-title] title)))
        (ph/row (ph/cell [:tp-list-text-cell] (ph/paragraph [:tp-list-text] content)))))))


(defn with-optional-metadata [options]
  (if-let [font (:font options)]
    (assoc style-def/pdf-report-metadata :font {:encoding :unicode :ttf-name font})
    style-def/pdf-report-metadata))

(defn- escape-html
  "Change special characters into HTML character entities."
  [text]
  (.. #^String (str text)
      (replace "&" "&amp;")
      (replace "<" "&lt;")
      (replace ">" "&gt;")
      (replace "\"" "&quot;")))


(defn right-header [row1 date-now]
  (let [row2 (format "Report generated on: %s" (styling/instant->printable-string-with-time date-now))
        row1-escaped (escape-html row1)
        svg-string
        (format
         "<svg width=\"350\" height=\"60\" xmlns=\"http://www.w3.org/2000/svg\">
           <text text-anchor=\"end\">
             <tspan x=\"350\" y=\"22\" font-family=\"helvetica\" font-size=\"11\" fill=\"white\">%s</tspan>
             <tspan x=\"350\" y=\"47\" font-family=\"helvetica\" font-size=\"11\" fill=\"white\">%s</tspan>
           </text>
         </svg>"
         row1-escaped row2)]
    [:svg {:translate [220 10]} svg-string]))



(defn title-page [{:keys [img-dir]} content]
  [[:svg {:translate [0 0] :scale 1.1} (styling/load-resource img-dir "titlepage-rectangle2.svg")]
   [:svg {:translate [0 -10] :scale 1.1} (styling/load-resource img-dir "titlepage-rectangle1.svg")]
   [:svg {:translate [40 30]} (styling/load-resource img-dir "titlepage-codescene-logo.svg")]
   [:svg {:under true :scale 0.8} (styling/load-resource img-dir "titlepage-background.svg")]
   content
   (ph/pagebreak)])


(defn info-with-score-color [score-cell-style title info-text]
  (ph/cell
    [:c-leftborder-cell score-cell-style]
    (ph/paragraph [:c-subheader] title)
    (ph/paragraph [:c-bigger-subheader] info-text)))


(defn link-row [url title img-dir]
  (let [arrow-icon (styling/load-resource img-dir "Arrow-right.png")]
    (ph/row
      (ph/cell [:c-link-text-cell] (ph/paragraph [] (ph/anchor [] {:target url} (ph/phrase [:c-link-text-phrase] title))))
      (ph/cell [:c-link-image-cell] (ph/image [:c-link-image] arrow-icon)))))

(defn link-row-small [url title img-dir]
  (let [arrow-icon (styling/load-resource img-dir "Arrow-right.png")]
    (ph/row
     (ph/cell [:c-link-text-cell] (ph/paragraph [] (ph/anchor [] {:target url} (ph/phrase [:c-link-small-text-phrase] title))))
     (ph/cell [:c-link-image-cell] (ph/image [:c-link-small-image] arrow-icon)))))

(defn content-page [{img-dir :img-dir} right-header contents]
  [[:svg {} (styling/load-resource img-dir "contentpage-rectangle.svg")]
   [:svg {:translate [20 20] :scale 0.8} (styling/load-resource img-dir "contentpage-codescene-logo.svg")]
   right-header
   (for [content contents] content)
   (ph/pagebreak)])
