(ns codescene.features.recommendations.mock
  "Temporary ns for centralizing the mocked data."
  (:require
   [codescene.features.recommendations.definitions.recommendations :as recommendation-defs]))


(def mock-presentable-recommendations
      [{:id :stopdcl
       :title (-> recommendation-defs/all :stopdcl :title)
       :category (-> recommendation-defs/all :stopdcl :category)
       :init-time "2024-02-29"
       :issues-paragraphs ["6 files decline in Code Health, meaning they are now more expensive to maintain than they used to be."]
       :opportunity-paragraphs ["No matter where you're starting from, you never want your code to get worse and to take on additional technical debt."
                                "By implementing “Quality Gates” for Hotspots you can improve and maintain a high level of Code Health."]
       :progress-items [{:title "Set quality gates on 6 of the 6 files (6/6)"
                         :status-text "2024-03-28"
                         :status :complete}
                        {:title "Goal violation on 1 of the 6 files"
                         ;; TODO: is the date relevant here? should we show this at all in this case?
                         :status-text "2024-03-28"
                         :status :in-progress}]
       :progress-percent 85}

      {:id :confpr
       :title  (-> recommendation-defs/all :confpr :title)
       :category (-> recommendation-defs/all :confpr :category)
       :init-time "2024-02-29"
       :issues-paragraphs ["CodeScene's PR integration is not configured for 3 of the four repositories in this project."]
       :opportunity-paragraphs ["Feedback on pull requests helps developers prevent technical debt from creeping back in to projects."
                                "Setting up the PR integration is easy and is the first step when trying to improve the Code Health of a project."]
       :progress-items [{:title "Configured PR integration on 1 of the 4 repositories"
                         :status-text "2024-02-19"
                         :status :in-progress}]
       :progress-percent 25}])
