(ns codescene.features.recommendations.definitions.recommendation-categories
  "The recommendation categories allow us to display related categories
  in similar ways (colors, badges, etc).")

;;; These can be used to define "categories of categories"
(def category-types
  {:risk {:category-type :risk}
   :improve {:category-type :improve}
   :learn {:category-type :learn}
   :configure {:category-type :configure}})


(def cat-defs
   [[:technical-debt :risk {:label "Technical debt" :icon :coin}]
    [:manage-risk :improve {:label "Manange risk" :icon :warn}]
    [:learn-codescene :learn {:label "Learn CodeScene" :icon :lightbulb}]])

(def recommendation-categories
  (into {}
        (map
         (fn [[k cat-type category]] [k (merge (get category-types cat-type) category {:id k :category-type cat-type})])
         cat-defs)))


(comment
{:technical-debt {:category-type :risk,
                  :label "Technical debt",
                  :icon :coin,
                  :id :technical-debt},
 :manage-risk {:category-type :improve,
               :label "Manange risk",
               :icon :warn,
               :id :manage-risk}}

)
