(ns codescene.features.pm-data.shortcut.cache
  "Wraps some fetcher fns to make them cacheable"
  (:require [codescene.features.pm-data.shortcut.shortcut-fetcher :as f]
            [codescene.features.pm-data.cache :as cache]))

(defn- fetch-issues-key-fn
  [_ _ project]
  [project])

(def ^:private fetch-issues-cacheable (cache/make-cacheable f/fetch-issues))
(cache/memo #'fetch-issues-cacheable fetch-issues-key-fn)

(defn fetch-issues
  [since api-client project]
  (cache/combine-with-cache fetch-issues-cacheable fetch-issues-key-fn
                            since api-client project))

(comment
  (def api-client (codescene.features.pm-data.shortcut.shortcut-api/shortcut-auth (System/getenv "SHORTCUT_TOKEN")))
  (def project "API")
  (let [since (evolutionary-metrics.trends.dates/string->date "2022-01-01")]
    (codescene.cache.core/with-file-cache "." "." :pm-data
      {:issues (count (fetch-issues since api-client project))}))
  )

