(ns codescene.features.pm-data.clickup.pm-data-provider
  (:require [codescene.pm-data.pm-data-provider :refer [PmDataProvider]]
            [codescene.features.pm-data.clickup.fetcher :as f]
            [codescene.features.pm-data.clickup.cache :as c]
            [codescene.features.pm-data.clickup.ticket-id-extractor :as x]
            [codescene.features.pm-data.pm-data-configuration :refer [PmDataConfiguration]]
            [codescene.features.pm-data.pm-data-provider :refer [-create-pm-data-provider -uses-supported-work-types]]
            [taoensso.timbre :as log]))

(defn- get-pm-data
  [{:keys [api-client external-project-ids] :as provider-def} {:keys [since] :as _pm-data-context}]
  ;; Note that c/fetch-tasks is cached and thus will only happen once,
  ;; even though it's called in two places
  (let [issues (c/fetch-tasks since api-client external-project-ids)]
    {:issues (into [] issues)
     :provider-def provider-def}))

(defn- make-ticket-id-extractor
  [{:keys [api-client external-project-ids] :as provider-def} {:keys [since] :as _pm-data-context}]
  (let [issues (c/fetch-tasks since api-client external-project-ids)]
    (x/make-ticket-id-extractor provider-def issues)))

(defn- get-configuration-data [{:keys [api-client] :as _provider-def}]
  (log/info "Fetching configuration data from ClickUp")
  (let [spaces (->> (f/fetch-all-spaces api-client) (sort-by :name))]
    {:work-types  (->> (f/fetch-all-task-types api-client) (sort-by :name))
     :transitions (->> (f/fetch-all-space-statuses api-client spaces) (sort-by :name))
     :projects    (mapv #(select-keys % [:key :name]) spaces)}))

(defn- validate-settings [{:keys [api-client] :as _provider-def}]
  (f/fetch-teams api-client)
  nil)

(deftype ClickUpProvider [provider-def pm-data-context]
  PmDataProvider
  (-make-ticket-id-extractor [_this _repo] (make-ticket-id-extractor provider-def pm-data-context))
  (-get-pm-data [_this] (get-pm-data provider-def pm-data-context))
  PmDataConfiguration
  (-get-configuration-data [_this] (get-configuration-data provider-def))
  (-validate-settings [_this] (validate-settings provider-def)))

(defmethod -create-pm-data-provider "clickup"
  [provider-def pm-data-context]
  (->ClickUpProvider provider-def pm-data-context))

(defmethod -uses-supported-work-types "clickup"
  [_provider-def]
  false)

(comment
  (def repo-url "https://github.com/dotnet/aspnetcore.git")
  (def context {:repo-urls [repo-url]})
  (def api-client (codescene.features.pm-data.clickup.api/clickup-auth (System/getenv "CLICKUP_TOKEN")))
  (def provider-def {:external-project-ids ["901505265095"]
                     :cost-unit "issues"
                     :defect-and-failure-labels ["Defect"]
                     :work-in-progress-transition-names ["IN PROGRESS" "IN DEVELOPMENT"]
                     :work-done-transition-names ["Done"]
                     :api-client api-client})
  (def since (evolutionary-metrics.trends.dates/string->date "2024-07-25"))
  (get-configuration-data provider-def)
  (get-pm-data provider-def {:since since})
  )
