(ns codescene.features.plugins.configuration
  "Some helper methods for managing configuration settings"
  (:require [codescene.crypto.encryptor :as encryptor]
            [clj-codescene-plugin.setting :as setting]))

(defn- make-lookup [settings kw]
  (->> settings
       (map (juxt :id kw))
       (into {})))

(defn- make-value-lookup [settings]
  (make-lookup settings :value))

(defn- encrypt-value [encryptor {:keys [value type] :as s}]
  (assoc s :value
         (if (setting/encrypted-setting-type? type)
           (mapv (partial encryptor/encrypt encryptor) value)
           value)))

(defn encrypt-values
  "Encrypt values for encrypted types (if not already encrypted)"
  [encryptor extension-settings]
  (map (partial encrypt-value encryptor) extension-settings))

(defn- decrypt-value [encryptor {:keys [type value] :as setting}]
  (assoc setting :value 
         (if (setting/encrypted-setting-type? type)
           (mapv (partial encryptor/decrypt encryptor) value)
           value)))

(defn decrypt-values
  "Decrypts values for encrypted types"
  [encryptor extension-settings]
  (map (partial decrypt-value encryptor) extension-settings))

(defn- synchronize-setting
  [{:keys [id default-value] :as setting} ->value]
  (assoc setting :value (or (->value id) default-value)))

(defn synchronize-settings 
  "Synchronize settings, ie attach looked up values (if there are any)"
  [extension-settings values]
  (let [->value (make-value-lookup values)]
    (map #(synchronize-setting % ->value) extension-settings)))