(ns codescene.features.plugins
  (:require [codescene.features.plugins.plugin-manager :as pm]
            [codescene.features.spec.components :as components-spec]
            [integrant.core :as ig]
            [clojure.spec.alpha :as s]))

(defmethod ig/init-key ::plugin-manager
  [_ {:keys [env] :as _conf}]
  (pm/init env))

(defmethod ig/pre-init-spec ::plugin-manager [_]
  (s/keys :req-un [::components-spec/env]))

(defmethod ig/halt-key! ::plugin-manager [_ plugin-manager]
  (pm/shutdown plugin-manager))

(defmethod ig/init-key ::plugins [_ conf] conf)

(defmethod ig/pre-init-spec ::plugins [_]
  (s/keys :req-un [::components-spec/encryptor
                   ::components-spec/plugin-manager]))

(derive ::plugins :codescene/component)
