(ns codescene.features.code-coverage.parser
  (:refer-clojure :exclude [name]))

(defprotocol Parser
  (-read-coverage [this reader parse-options]) ; parse-options indicate the level of parsing we have to do: shallow, or detailed (coverage by line for 'check')
  (-supported-metrics [this])
  (-id [this])
  (-name [this]))

(defn read-coverage [parser reader parse-options]
  (-read-coverage parser reader parse-options))

(defn supported-metrics [parser]
  (-supported-metrics parser))

(defn id [parser]
  (-id parser))

(defn name [parser]
  (-name parser))
