-- :name select-cov-gates :? :*
SELECT * FROM project_cov_gates WHERE project_id = :project_id

-- :name update-cov-gates-prop! :! :n
update project_cov_gates SET setting_value = :setting_value WHERE project_id = :project_id and setting_key = :setting_key;

-- :name insert-cov-gates-prop! :insert
insert into project_cov_gates(project_id, setting_key, setting_value) values (:project_id, :setting_key, :setting_value);

-- :name delete-cov-gates-prop! :! :n
delete from project_cov_gates where project_id = :project_id AND setting_key = :setting_key

-- :name elsewhere-enabled-repos :? :*
select pr.url as repo_url
from project_repositories pr
         join projects p on pr.project_id = p.id
         join project_cov_gates pcg on pcg.project_id = p.id
where url in (select url from project_repositories where project_id = :project_id)
  and p.status = 'created' and p.id != :project_id and pcg.setting_key = 'enabled?';